% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmall.R
\name{dmall}
\alias{dmall}
\title{Mallows density function}
\usage{
dmall(Pi, pi0, theta, log = FALSE)
}
\arguments{
\item{Pi}{Matrix of partial or complete rankings, one row per ranking.}

\item{pi0}{Vector specifying the consensus (modal probability) ranking.}

\item{theta}{Numeric specifying the Mallows scale parameter.}

\item{log}{Boolean indicating if loglikelihood should be returned.}
}
\value{
(Log) likelihood of rankings under a Mallows distribution.
}
\description{
This function calculates the density of observation(s) under a Mallows distribution.
}
\examples{
Pi <- matrix(c(1,2,3,4,2,1,NA,NA),byrow=TRUE,nrow=2)
dmall(Pi=Pi,pi0=c(2,1,3,4),theta=1,log=TRUE)
 
}
