/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.tokenize.AbstractTokenizer;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public final class ParserTool
extends BasicCmdLineTool {
    private static Pattern untokenizedParenPattern1 = Pattern.compile("([^ ])([({)}])");
    private static Pattern untokenizedParenPattern2 = Pattern.compile("([({)}])([^ ])");

    @Override
    public String getShortDescription() {
        return "performs full syntactic parsing";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " [-bs n -ap n -k n -tk tok_model] model < sentences \n" + "-bs n: Use a beam size of n.\n" + "-ap f: Advance outcomes in with at least f% of the probability mass.\n" + "-k n: Show the top n parses.  This will also display their log-probablities.\n" + "-tk tok_model: Use the specified tokenizer model to tokenize the sentences. " + "Defaults to a WhitespaceTokenizer.";
    }

    public static Parse[] parseLine(String line, Parser parser, int numParses) {
        return ParserTool.parseLine(line, parser, WhitespaceTokenizer.INSTANCE, numParses);
    }

    public static Parse[] parseLine(String line, Parser parser, Tokenizer tokenizer, int numParses) {
        line = untokenizedParenPattern1.matcher(line).replaceAll("$1 $2");
        line = untokenizedParenPattern2.matcher(line).replaceAll("$1 $2");
        List<String> tokens = Arrays.asList(tokenizer.tokenize(line));
        String text = String.join((CharSequence)" ", tokens);
        Parse p = new Parse(text, new Span(0, text.length()), "INC", 0.0, 0);
        int start = 0;
        int i = 0;
        for (String tok : tokens) {
            p.insert(new Parse(text, new Span(start, start + tok.length()), "TK", 0.0, i));
            start += tok.length() + 1;
            ++i;
        }
        Parse[] parses = numParses == 1 ? new Parse[]{parser.parse(p)} : parser.parse(p, numParses);
        return parses;
    }

    @Override
    public void run(String[] args) {
        if (args.length < 1) {
            System.out.println(this.getHelp());
        } else {
            boolean showTopK;
            Integer numParses;
            ParserModel model = (ParserModel)new ParserModelLoader().load(new File(args[args.length - 1]));
            Integer beamSize = CmdLineUtil.getIntParameter("-bs", args);
            if (beamSize == null) {
                beamSize = 20;
            }
            if ((numParses = CmdLineUtil.getIntParameter("-k", args)) == null) {
                numParses = 1;
                showTopK = false;
            } else {
                showTopK = true;
            }
            Double advancePercentage = CmdLineUtil.getDoubleParameter("-ap", args);
            if (advancePercentage == null) {
                advancePercentage = 0.95;
            }
            AbstractTokenizer tokenizer = WhitespaceTokenizer.INSTANCE;
            String tokenizerModelName = CmdLineUtil.getParameter("-tk", args);
            if (tokenizerModelName != null) {
                TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(new File(tokenizerModelName));
                tokenizer = new TokenizerME(tokenizerModel);
            }
            Parser parser = ParserFactory.create(model, beamSize, advancePercentage);
            PlainTextByLineStream lineStream = null;
            PerformanceMonitor perfMon = null;
            try {
                String line;
                lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());
                perfMon = new PerformanceMonitor(System.err, "sent");
                perfMon.start();
                while ((line = (String)lineStream.read()) != null) {
                    if (line.trim().length() == 0) {
                        System.out.println();
                        continue;
                    }
                    Parse[] parses = ParserTool.parseLine(line, parser, tokenizer, numParses);
                    int pn = parses.length;
                    for (int pi = 0; pi < pn; ++pi) {
                        if (showTopK) {
                            System.out.print(pi + " " + parses[pi].getProb() + " ");
                        }
                        parses[pi].show();
                        perfMon.incrementCounter();
                    }
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

