% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{rp.desc}
\alias{rp.desc}
\title{Descriptive Statistics}
\usage{
rp.desc(
  measure.vars,
  id.vars = NULL,
  fn,
  data = NULL,
  na.rm = FALSE,
  margins = TRUE,
  total.name = "Total",
  use.labels = getOption("rapport.use.labels")
)
}
\arguments{
\item{measure.vars}{either a character vector with variable names from \code{data}, a numeric vector, or a \code{data.frame}}

\item{id.vars}{same rules apply as in \code{measure.vars}, but defaults to \code{NULL}}

\item{fn}{a list with functions or a character vector with function names}

\item{data}{a \code{data.frame} holding variables specified in \code{id.vars} and \code{measure.vars}}

\item{na.rm}{a logical value indicating whether \code{NA} values should be removed}

\item{margins}{should margins be included?}

\item{total.name}{a character string with name for "grand" margin (defaults to "Total")}

\item{use.labels}{use labels instead of variable names in table header (handle with care, especially if you have lengthy labels). Defaults to value specified in \code{rapport.use.labels} option.}
}
\value{
a \code{data.frame} with aggregated data
}
\description{
Aggregate table of descriptives according to functions provided in \code{fn} argument. This function follows melt/cast approach used in \code{reshape} package. Variable names specified in \code{measure.vars} argument are treated as \code{measure.vars}, while the ones in \code{id.vars} are treated as \code{id.vars} (see \code{\link[reshape]{melt.data.frame}} for details). Other its formal arguments match with corresponding arguments for \code{\link[reshape]{cast}} function. Some post-processing is done after reshaping, in order to get pretty row and column labels.
}
\examples{
rp.desc("cyl", NULL, c(mean, sd), mtcars)
rp.desc("cyl", "am", c(mean, sd), mtcars, margins = TRUE)
rp.desc("hp", c("am", "gear"), c("Average" = mean, "Deviation" = sd), mtcars)
}
