% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rateci.R
\name{rateci}
\alias{rateci}
\title{Selected confidence intervals for the single binomial or Poisson rate.}
\usage{
rateci(x, n, distrib = "bin", level = 0.95, cc = FALSE, precis = 6)
}
\arguments{
\item{x}{Numeric vector of number of events.}

\item{n}{Numeric vector of sample size (for binomial rate) or exposure
times (for Poisson rate).}

\item{distrib}{Character string indicating distribution assumed for the input
data: "bin" = binomial (default), "poi" = Poisson.}

\item{level}{Number specifying confidence level (between 0 and 1, default
0.95).}

\item{cc}{Number or logical (default FALSE) specifying continuity
correction.}

\item{precis}{Number (default 6) specifying precision (i.e. number of decimal
places) to be used in optimisation subroutine for the SCAS and exact methods.}
}
\value{
A list containing, for each method, a matrix containing lower and upper
confidence limits for each value of x and n. Methods shown depend on the cc
parameter, which specifies whether the continuity correction is applied to
the SCAS and Jeffreys methods. The corresponding 'exact' method is
Clopper-Pearson/Garwood if cc == TRUE and mid-p if cc == FALSE.
}
\description{
Confidence intervals for the single binomial or Poisson rate. Including
SCAS or Jeffreys intervals, with or without continuity correction, and
'exact' Clopper-Pearson/Garwood or mid-p intervals.
This function is vectorised in x, n.
}
\author{
Pete Laud, \email{p.j.laud@sheffield.ac.uk}
}
