% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\docType{methods}
\name{permuteVariables}
\alias{permuteVariables}
\alias{permuteVariables,ratioOfQsprays,numeric-method}
\title{Permute variables}
\usage{
\S4method{permuteVariables}{ratioOfQsprays,numeric}(x, permutation)
}
\arguments{
\item{x}{a \code{ratioOfQsprays} object}

\item{permutation}{a permutation}
}
\value{
A \code{ratioOfQsprays} object.
}
\description{
Permute the variables of a \code{ratioOfQsprays} fraction
  of polynomials.
}
\examples{
library(ratioOfQsprays)
f <- function(x, y, z) {
  (x^2 + 5*y + z - 1) / (x + 1)
}
x <- qlone(1)
y <- qlone(2)
z <- qlone(3)
R <- f(x, y, z)
permutation <- c(3, 1, 2)
S <- permuteVariables(R, permutation)
S == f(z, x, y) # should be TRUE
}
