% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rave-prepare-subjectbare.R, R/rave-prepare.R
\name{prepare_subject_bare}
\alias{prepare_subject_bare}
\alias{prepare_subject_with_epoch}
\alias{prepare_subject_power}
\alias{rave-prepare}
\title{Prepare 'RAVE' single-subject data}
\usage{
prepare_subject_bare(subject, electrodes, reference_name, ...)

prepare_subject_with_epoch(
  subject,
  electrodes,
  reference_name,
  epoch_name,
  time_windows,
  env = parent.frame(),
  ...
)

prepare_subject_power(
  subject,
  electrodes,
  reference_name,
  epoch_name,
  time_windows,
  signal_types = c("LFP"),
  env = parent.frame(),
  ...
)
}
\arguments{
\item{subject}{character of project and subject, such as \code{"demo/YAB"},
or \code{\link{RAVESubject}} instance}

\item{electrodes}{integer vector of electrodes, or a character that can be
parsed by \code{\link[dipsaus]{parse_svec}}}

\item{reference_name}{reference name to be loaded}

\item{...}{ignored}

\item{epoch_name}{epoch name to be loaded, or a
\code{\link{RAVEEpoch}} instance}

\item{time_windows}{a list of time windows that are relative to epoch onset
time; need to pass the validation \code{\link{validate_time_window}}}

\item{env}{environment to evaluate}

\item{signal_types}{electrode signal types to be considered; default is
'LFP'. This option rarely needs to change unless you really want to check
the power data from other types. For other signal types, check
\code{\link{SIGNAL_TYPES}}}
}
\value{
A \code{\link[dipsaus]{fastmap2}} (basically a list) of objects.
Depending on the functions called, the following items may exist in the list:
\describe{
\item{\code{subject}}{A \code{\link{RAVESubject}} instance}
\item{\code{epoch_name}}{Same as input \code{epoch_name}}
\item{\code{epoch}}{A \code{\link{RAVEEpoch}} instance}
\item{\code{reference_name}}{Same as input \code{reference_name}}
\item{\code{reference_table}}{A data frame of reference}
\item{\code{electrode_table}}{A data frame of electrode information}
\item{\code{frequency}}{A vector of frequencies}
\item{\code{time_points}}{A vector of time-points}
\item{\code{power_list}}{A list of power data of the electrodes}
\item{\code{power_dimnames}}{A list of trial indices, frequencies, time
points, and electrodes that are loaded}
}
}
\description{
Prepare 'RAVE' single-subject data
}
