% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bids.R
\name{load_bids_ieeg_header}
\alias{load_bids_ieeg_header}
\title{Read in description files from 'BIDS-iEEG' format}
\usage{
load_bids_ieeg_header(bids_root, project_name, subject_code, folder = "ieeg")
}
\arguments{
\item{bids_root}{'BIDS' root directory}

\item{project_name}{project folder name}

\item{subject_code}{subject code, do not include \code{"sub-"} prefix}

\item{folder}{folder name corresponding to 'iEEG' data. It's possible to
analyze other folders. However, by default, the function is designed for
\code{'ieeg'} folder.}
}
\value{
A list containing the information below:
\item{subject_code}{character, removed leading \code{"sub-"}}
\item{project_name}{character, project name}
\item{has_session}{whether session/block names are indicated
by the file structure}
\item{session_names}{session/block names indicated by file
structure. If missing, then session name will be "default"}
\item{paths}{a list containing path information}
\item{stimuli_path}{stimuli path, not used for now}
\item{sessions}{
A named list containing meta information for each session/block. The
names of the list is task name, and the items corresponding to the
task contains events and channel information. Miscellaneous files
are stored in "others" variable.
}
}
\description{
Analyze file structures and import all \code{json} and
\code{tsv} files. File specification can be found at
\url{https://bids-specification.readthedocs.io/en/stable/}, chapter
"Modality specific files", section "Intracranial Electroencephalography"
(\doi{10.1038/s41597-019-0105-7}). Please note that this function has
very limited support on BIDS format.
}
\examples{

# Download https://github.com/bids-standard/bids-examples/
# extract to directory ~/rave_data/bids_dir/

bids_root <- '~/rave_data/bids_dir/'
project_name <- 'ieeg_visual'

if(dir.exists(bids_root) &&
   dir.exists(file.path(bids_root, project_name, 'sub-01'))){

  header <- load_bids_ieeg_header(bids_root, project_name, '01')

  print(header)

  # sessions
  names(header$sessions)

  # electrodes
  head(header$sessions$`01`$spaces$unknown_space$table)

  # visual task channel settings
  head(header$sessions$`01`$tasks$`01-visual-01`$channels)

  # event table
  head(header$sessions$`01`$tasks$`01-visual-01`$channels)
}

}
