% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Vector3.R
\name{new_vector3}
\alias{new_vector3}
\alias{as_vector3}
\title{Create a \code{Vector3} instance to store '3D' points}
\usage{
new_vector3(x = 0, y = 0, z = 0)

as_vector3(v)
}
\arguments{
\item{x, y, z}{numeric, must have the same length, \code{'xyz'} positions}

\item{v}{R object to be converted to \code{Vector3} instance}
}
\value{
A \code{Vector3} instance
}
\description{
Create instances that mimic the \code{'three.js'} syntax.
}
\examples{

vec3 <- new_vector3(
  x = 1:9,
  y = 9:1,
  z = rep(c(1,2,3), 3)
)

vec3[]

# transform
m <- new_matrix4()

# rotation xy plane by 30 degrees
m$make_rotation_z(pi / 6)

vec3$apply_matrix4(m)

vec3[]

as_vector3(c(1,2,3))

}
\seealso{
\code{\link{new_matrix4}}, \code{\link{new_quaternion}}
}
