% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_molecule.R
\name{get_molecule}
\alias{get_molecule}
\title{Get Molecule}
\usage{
get_molecule(molecule)
}
\arguments{
\item{molecule}{A character variable of a compound name or a numeric variable of an official compound ID}
}
\value{
List giving the atom locations and the connections between atoms.
}
\description{
Loads the structure of a molecule by fetching an SDF file from Pubchem, which can be piped to generate_full_scene
}
\examples{
\donttest{
get_molecule("caffeine") \%>\%
  generate_full_scene() \%>\%
  render_model()

#estradiol (aka estrogen)
get_molecule(5757) \%>\%
  generate_full_scene() \%>\%
  render_model()

get_molecule("testosterone") \%>\%
  generate_full_scene() \%>\%
  render_model()

get_molecule("aspirin") \%>\%
  generate_full_scene() \%>\%
  render_model()

get_molecule("rutoside") \%>\%
  generate_full_scene() \%>\%
  render_model()

#If the 3D SDF doesn't exist, this function will pull the 2D SDF and inform the user
get_molecule("cyanocobalamin") \%>\%
  generate_full_scene() \%>\%
  render_model()
}
}
