% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_scale}
\alias{csg_scale}
\title{CSG Scale}
\usage{
csg_scale(object, scale = 1)
}
\arguments{
\item{object}{CSG object.}

\item{scale}{Default `1`.}
}
\value{
List describing the triangle in the scene.
}
\description{
CSG Scale
}
\examples{
if(run_documentation()) {
#Scale a pyramid (translating it upwards because the object is scaled from the center):
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_pyramid(z=1,y=-0.99),
                        material=glossy(color="red"))) \%>\% 
  add_object(csg_object(csg_scale(csg_pyramid(z=-1,y=-0.5),2),
                        material=glossy(color="green"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,material=light(intensity=40))) \%>\% 
  render_scene(lookfrom=c(-3,4,10), fov=20, 
               lookat=c(0,-0.5,-0.5),clamp_value=10)
}
}
