% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_ticks.R
\name{RandomTicks}
\alias{RandomTicks}
\alias{get_random_ticks_data}
\alias{get_random_ticks_value}
\alias{put_random_ticks_data}
\alias{put_random_ticks_value}
\title{Load and store RandomTicks NBT data}
\usage{
get_random_ticks_data(x, z, dimension, db = default_db())

get_random_ticks_value(x, z, dimension, db = default_db())

put_random_ticks_data(values, x, z, dimension, db = default_db())

put_random_ticks_value(value, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{values}{A (named) list of list of NBT objects.}

\item{value}{A list of NBT objects.}
}
\value{
\code{get_random_ticks_value()} returns a list of NBT objects.
\code{get_random_ticks_data()} returns a named list of lists of NBT objects.
}
\description{
RandomTicks data (tag 59) holds a list of NBT values for
random ticks.
}
\details{
\itemize{
\item \code{get_random_ticks_value()} and \code{get_random_ticks_data()} load RandomTicks
data from \code{db}. \code{get_random_ticks_value()} loads data for a single chunk,
and \code{get_random_ticks_data()} loads data for multiple chunks.
\item \code{put_random_ticks_value()} and \code{put_random_ticks_data()} store RandomTicks
data for one or multiple chunks into \code{db}.
}
}
