\name{bhl_getauthortitles}
\alias{bhl_getauthortitles}
\title{Return a list of titles associated with a given BHL author identifier.}
\usage{
bhl_getauthortitles(creatorid = NA, format = "json", output = "list",
  key = NULL, callopts = list())
}
\arguments{
  \item{creatorid}{BHL identifier for a particular author
  (numeric)}

  \item{format}{either XML ('xml') or JSON ('json') format.
  If output='list', format is forced to equal 'json'}

  \item{output}{Return a list, raw json or xml, or parsed
  data (character).  Default: 'list'}

  \item{key}{your BHL API key, either enter, or loads from
  .Rprofile}

  \item{callopts}{Call options passed on to httr::GET.}
}
\description{
Unless the identifier for a particular BHL author record is
known in advance, this method should be used in combination
with the AuthorSearch method.
}
\examples{
\dontrun{
bhl_getauthortitles(1970)
bhl_getauthortitles(1970, output='raw')
bhl_getauthortitles(1970, output='raw', format='xml')
}
}

