% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_interaction_partners}
\alias{rba_string_interaction_partners}
\title{Get All STRING Interaction Partners}
\usage{
rba_string_interaction_partners(
  ids,
  species = NULL,
  required_score = NULL,
  network_type = "functional",
  limit = NULL,
  ...
)
}
\arguments{
\item{ids}{Your protein ID(s). It is strongly recommended to supply
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{required_score}{Numeric: A minimum of interaction score for an
interaction to be included in the image. if not supplied, the threshold
will be applied by STRING Based in the network. (low Confidence = 150,
Medium Confidence = 400, High Confidence = 700, Highest confidence = 900)}

\item{network_type}{should be one of:\itemize{
\item "functional": (default) The edge's indicate both physical and
functional associations.}}

\item{limit}{Limit the number returned interaction partners per each of
your input proteins. (e.g. Number of the most confident interaction partner
to return per each input protein.)}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame which each row is a network interaction and the
  columns contains interactor information and interaction scores.
}
\description{
This function will retrieve all the STRING interactions which include your
  proteins as one party of the interaction. (e.g. interaction between your
  proteins and every other STRING proteins.)
  \cr Given the size of STRING database, this function could return a very
  long results. See "Arguments" section for information on how to filter
  the interactions.
}
\details{
Note that this function will retrieve the interactions between your input
  proteins and every other STRING proteins. To retrieve the interaction
  among your input protein-set, see
  \code{\link{rba_string_interactions_network}}.
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/[output-format]/
 interaction_partners?identifiers=[your_identifiers]&[optional_parameters]"
}

\examples{
\donttest{
rba_string_interaction_partners(ids = c("9606.ENSP00000269305",
    "9606.ENSP00000398698",
    "9606.ENSP00000275493"),
    network_type = "functional")
}
\donttest{
    rba_string_interaction_partners(ids = "9606.ENSP00000269305",
    species = 9606,
    required_score = 700)
}

}
\references{
\itemize{
  \item Szklarczyk D, Gable AL, Lyon D, Junge A, Wyder S, Huerta-Cepas J,
  Simonovic M, Doncheva NT, Morris JH, Bork P, Jensen LJ, Mering CV.
  STRING v11: protein-protein association networks with increased coverage,
  supporting functional discovery in genome-wide experimental datasets.
  Nucleic Acids Res. 2019 Jan 8;47(D1):D607-D613. doi: 10.1093/nar/gky1131.
  PMID: 30476243; PMCID: PMC6323986.
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  }
}
\seealso{
\code{\link{rba_string_map_ids}, \link{rba_string_interactions_network}}

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
