% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\name{nsamples}
\alias{nsamples}
\title{Number of samples in a BIOM.}
\usage{
nsamples(biom)
}
\arguments{
\item{biom}{A \code{BIOM} object, as returned from \link{read.biom}.}
}
\value{
The number of samples present.
}
\description{
Number of samples in a BIOM.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read.biom(infile)
    
    nsamples(biom)

}
\seealso{
Other accessor functions: 
\code{\link{counts}()},
\code{\link{info}()},
\code{\link{metadata}()},
\code{\link{ntaxa}()},
\code{\link{phylogeny}()},
\code{\link{sample.names}()},
\code{\link{sequences}()},
\code{\link{taxa.names}()},
\code{\link{taxa.ranks}()},
\code{\link{taxonomy}()}
}
\concept{accessor functions}
