% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distmat_ord_table.r
\name{distmat_ord_table}
\alias{distmat_ord_table}
\title{Run ordinations on a distance matrix.}
\usage{
distmat_ord_table(dm, ord = "PCoA", k = 2L, ...)
}
\arguments{
\item{dm}{A \code{dist}-class distance matrix, as returned from
\code{\link[=bdiv_distmat]{bdiv_distmat()}} or \code{\link[stats:dist]{stats::dist()}}. Required.}

\item{ord}{Method for reducing dimensionality. Options are:
\describe{
\item{\code{"PCoA"} - }{ Principal coordinate analysis; \code{\link[ape:pcoa]{ape::pcoa()}}. }
\item{\code{"UMAP"} - }{ Uniform manifold approximation and projection; \code{\link[uwot:umap]{uwot::umap()}}. }
\item{\code{"NMDS"} - }{ Nonmetric multidimensional scaling; \code{\link[vegan:metaMDS]{vegan::metaMDS()}}. }
\item{\code{"tSNE"} - }{ t-distributed stochastic neighbor embedding; \code{\link[tsne:tsne]{tsne::tsne()}}. }
}
Multiple/abbreviated values allowed. Default: \code{"PCoA"}}

\item{k}{Number of ordination dimensions to return. Either \code{2L} or
\code{3L}. Default: \code{2L}}

\item{...}{Additional arguments for \code{ord}.}
}
\value{
A data.frame with columns \code{.sample}, \code{.ord}, \code{.x},
\code{.y}, and (optionally) \code{.z}.
}
\description{
Run ordinations on a distance matrix.
}
\examples{
    library(rbiom) 
    
    dm  <- bdiv_distmat(hmp50, "bray")
    ord <- distmat_ord_table(dm, "PCoA")
    head(ord)
    
}
\seealso{
Other ordination: 
\code{\link{bdiv_ord_plot}()},
\code{\link{bdiv_ord_table}()}
}
\concept{ordination}
