% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{getStrategies}
\alias{getStrategies}
\title{Get imputation strategies}
\usage{
getStrategies(...)
}
\arguments{
\item{...}{User defined methods to be added to the return list. Input must
be a function.}
}
\description{
Returns a list defining the imputation strategies to be used to create the
multivariate normal distribution parameters by merging those of the source
group and reference group per patient.
}
\details{
By default Jump to Reference (JR), Copy Reference (CR), Copy Increments in
Reference (CIR), Last Mean Carried Forward (LMCF) and Missing at Random (MAR)
are defined.

The user can define their own strategy functions (or overwrite the pre-defined ones)
by specifying a named input to the function i.e. \code{NEW = function(...) ...}.
Only exception is MAR which cannot be overwritten.

All user defined functions must take 3 inputs: \code{pars_group}, \code{pars_ref} and
\code{index_mar}. \code{pars_group} and \code{pars_ref} are both lists with elements \code{mu}
and \code{sigma} representing the multivariate normal distribution parameters for
the subject's current group and reference group respectively.  \code{index_mar} will be
a logical vector specifying which visits the subject met the MAR assumption
at. The function must return a list with elements \code{mu} and \code{sigma}. See the implementation
of \code{strategy_JR()} for an example.
}
\examples{
\dontrun{
getStrategies()
getStrategies(
    NEW = function(pars_group, pars_ref, index_mar) code ,
    JR = function(pars_group, pars_ref, index_mar)  more_code
)
}

}
