% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse.R
\name{extract_imputed_df}
\alias{extract_imputed_df}
\title{Extract imputed dataset}
\usage{
extract_imputed_df(imputation, ld, delta = NULL, idmap = FALSE)
}
\arguments{
\item{imputation}{An imputation object as generated by \code{\link[=imputation_df]{imputation_df()}}.}

\item{ld}{A \code{longdata} object as generated by \code{\link[=longDataConstructor]{longDataConstructor()}}.}

\item{delta}{Either \code{NULL} or a \code{data.frame}. Is used to offset outcome values in the imputed dataset.}

\item{idmap}{Logical. If \code{TRUE} an attribute called "idmap" is attached to
the return object which contains a \code{list} that maps the old subject ids
the new subject ids.}
}
\value{
A \code{data.frame}.
}
\description{
Takes an imputation object as generated by \code{\link[=imputation_df]{imputation_df()}} and uses
this to extract a completed dataset from a \code{longdata} object as created
by \code{\link[=longDataConstructor]{longDataConstructor()}}. Also applies a delta transformation
if a \code{data.frame} is provided to the \code{delta} argument. See \code{\link[=analyse]{analyse()}} for
details on the structure of this \code{data.frame}.

Subject IDs in the returned \code{data.frame} are scrambled i.e. are not the original
values.
}
