% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_range.R
\name{x_range}
\alias{x_range}
\title{Update x axis range in a Bokeh figure}
\usage{
x_range(fig, dat = NULL, callback = NULL)
}
\arguments{
\item{fig}{figure to modify}

\item{dat}{either a vector (min, max) if the axis is numeric, or a vector of values if the axis is categorical.  In the latter case, the order in which the values are supplied is how they will be arranged on the axis.}

\item{callback}{TODO}
}
\description{
Update x axis range in a Bokeh figure
}
\examples{
\donttest{
# get data from Duluth site in 'barley' data
du <- subset(lattice::barley, site == "Duluth")

# plot with default ranges
p <- figure(width = 600) \%>\%
  ly_points(yield, variety, color = year, data = du)
p
# y axis is alphabetical

# manually set x and y axis (y in order of 1932 yield)
p \%>\%
  x_range(c(20, 40)) \%>\%
  y_range(du$variety[order(subset(du, year == 1932)$yield)])
}
}
\seealso{
Other ranges: \code{\link{y_range}}
}

