% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_grid.R
\name{theme_grid}
\alias{theme_grid}
\title{Override theme parameters for grid attributes}
\usage{
theme_grid(fig, which = c("x", "y"), band_fill_alpha = 1,
  band_fill_color = "gray", grid_line_alpha = 1, grid_line_cap = "butt",
  grid_line_color = "black", grid_line_dash = NULL,
  grid_line_dash_offset = 0, grid_line_join = "miter",
  grid_line_width = 1, minor_grid_line_alpha = 1,
  minor_grid_line_cap = "butt", minor_grid_line_color = "black",
  minor_grid_line_dash = NULL, minor_grid_line_dash_offset = 0,
  minor_grid_line_join = "miter", minor_grid_line_width = 1, pars = NULL)
}
\arguments{
\item{fig}{figure to modify}

\item{which}{which grids to apply attributes to ("x" and/or "y")}

\item{band_fill_alpha}{The fill alpha of alternating bands between Grid lines.}

\item{band_fill_color}{The fill color of alternating bands between Grid lines.}

\item{grid_line_alpha}{The line alpha of the Grid lines.}

\item{grid_line_cap}{('butt', 'round', 'square') The line cap of the Grid lines.}

\item{grid_line_color}{The line color of the Grid lines.}

\item{grid_line_dash}{The line dash of the Grid lines.}

\item{grid_line_dash_offset}{The line dash offset of the Grid lines.}

\item{grid_line_join}{('miter', 'round', 'bevel') The line join of the Grid lines.}

\item{grid_line_width}{The line width of the Grid lines.}

\item{minor_grid_line_alpha}{The line alpha of the minor Grid lines.}

\item{minor_grid_line_cap}{('butt', 'round', 'square') The line cap of the minor Grid lines.}

\item{minor_grid_line_color}{The line color of the minor Grid lines.}

\item{minor_grid_line_dash}{The line dash of the minor Grid lines.}

\item{minor_grid_line_dash_offset}{The line dash offset of the minor Grid lines.}

\item{minor_grid_line_join}{('miter', 'round', 'bevel') The line join of the minor Grid lines.}

\item{minor_grid_line_width}{The line width of the minor Grid lines.}

\item{pars}{optionally specify a named list of all parameters - useful when dealing with theme lists}
}
\description{
Override theme parameters for grid attributes
}
\examples{
\donttest{
# manually specify a ggplot-like grid and background
figure() \%>\%
  ly_points(1:10) \%>\%
  theme_plot(background_fill_color = "#E6E6E6",
    outline_line_color = "white") \%>\%
  theme_grid(c("x", "y"), grid_line_color = "white",
    minor_grid_line_color = "white",
    minor_grid_line_alpha = 0.4) \%>\%
  theme_axis(c("x", "y"), axis_line_color = "white",
    major_label_text_color = "#7F7F7F",
    major_tick_line_color = "#7F7F7F",
    minor_tick_line_alpha = 0, num_minor_ticks = 2)

# or use the built in ggplot theme (under development)
figure(data = iris, legend = "top_left", tools = NULL) \%>\%
  ly_points(Sepal.Length, Petal.Length, color = Species) \%>\%
  set_theme(bk_ggplot_theme)
}
\dontrun{
# or to set the theme for all future plots
options(bokeh_theme = bk_ggplot_theme)

figure() \%>\%
  ly_points(1:10)

figure() \%>\%
  ly_boxplot(1:10)
}
}

