% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radial.R
\name{radial}
\alias{radial}
\title{Gaussian Radial Basis Functions}
\usage{
radial(crd, knots, w = NULL, ..., longlat = TRUE)
}
\arguments{
\item{crd}{A matrix object. The (x,y) coordinates of the reference
points \{nCrd x 2\}.}

\item{knots}{A matrix object. The (x,y) coordinates of the knots \{r x 2\}.}

\item{w}{A numeric object. The positive scaling factor (bandwidth).}

\item{...}{ignored. Included only to require naming of inputs that follow.}

\item{longlat}{A logical object. If FALSE, Euclidean
distance is calculated; if TRUE, Great Circle distance is calculated.
See ?sp::spDists for more information.}
}
\value{
A matrix of Gaussian functions evaluated at all combinations of
 crd and knots \{ nCrd x r \}.
}
\description{
Provides an implementation of the Gaussian radial basis functions defined as
\deqn{ \Psi_{j}(s) =
 \exp\{- \frac{1}{2} (||s - c_j||/w)^2\}.}
}
\details{
Distances between reference coordinates and knots are obtained using 
  sp::spDists().
}
\examples{

  data(countyExample)

  radial(crd = sp::coordinates(county), knots = knots)

}
