% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sectors_segmentation.R
\name{sectors_segmentation}
\alias{sectors_segmentation}
\title{Sectors segmentation}
\usage{
sectors_segmentation(a, angle_width, return_angle = FALSE)
}
\arguments{
\item{a}{\code{\linkS4class{RasterLayer}} built with
\code{\link{azimuth_image}}.}

\item{angle_width}{Numeric vector of length one. Angle in degrees able to
divide the angle range into a whole number of segments.}

\item{return_angle}{Logical vector of length one. If it is \code{FALSE}, all
the pixels that belong to a segment are labeled with an ID number.
Otherwise, the angle mean of the segment is assigned to the pixels.}
}
\value{
An object from the class \linkS4class{RasterLayer} with segments
  shaped like pizza slices.
}
\description{
Segmenting an hemispherical view by slicing the azimuth angle from \code{0}
to \code{360º} in equals intervals.
}
\examples{
z <- zenith_image(1490, lens())
a <- azimuth_image(z)
sectors <- sectors_segmentation(a, 15)
plot(sectors == 1)
}
\seealso{
Other Segmentation functions: 
\code{\link{mask_hs}()},
\code{\link{rings_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation functions}
