% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{smoothGauss}
\alias{smoothGauss}
\title{Smooth a numeric vector using a Gaussian window}
\usage{
smoothGauss(x, alpha, window = 0.1)
}
\arguments{
\item{x}{numeric vector of values to smooth.}

\item{alpha}{numeric value controlling the size of the gaussian smoothing window. Proportional to the standard deviation of the Gaussian smoothing kernel where sd=(N-1)/(2*alpha) with N being the length of the input vector.}

\item{window}{a fraction between 0 and 1 representing the proportion of the input vector to include in the moving window.}
}
\description{
Smooth a numeric vector using a Gaussian window
}
\details{
Adapted from \code{smth.gaussian} in the \code{smoother} package.
}
\examples{
smoothGauss(runif(200),alpha=5)
}
\references{
Hamilton, N. (2015). smoother: Functions Relating to the Smoothing of Numerical Data, R package version 1.1, https://CRAN.R-project.org/package=smoother
}
