% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_references.R
\name{rcatfish_references}
\alias{rcatfish_references}
\title{Search for references in Eschmeyer's Catalog of Fishes}
\usage{
rcatfish_references(query, type, sleep.time = 10, verbose = TRUE)
}
\arguments{
\item{query}{Either a character vector of keywords to search for or a numeric vector with reference numbers}

\item{type}{Either "RefNo" if searching for a reference number or "keyword" if searching by keywords
reference numbers.}

\item{sleep.time}{Numeric. Time in seconds to sleep between query calls to the California Academy of Sciences page. This is set by default to 10 seconds, which is in their robots.txt. Adjust at your own risk.}

\item{verbose}{Logical. Should query progress be messaged to the screen? Default is TRUE.}
}
\value{
A data.frame containing columns for the query, reference number, and full citation.
}
\description{
Search for references in the Catalog of Fishes by keyword or reference number.
}
\details{
This function searches Catalog of Fishes references. Users can supply either a keyword
(i.e. cichlidae, revision, etc.) or a reference number to retrieve reference information.
}
\examples{
#Perform a search of references that contain the keyword Amphilophus.
my.refs<-rcatfish_references(query = "Amphilophus", type = "keyword")
#Perform a search of references based on a Catalog of Fishes reference number
my.refs<-rcatfish_references(query = 2787, type = "RefNo")
}
\references{
Fricke, R. (Year Accessed). Eschmeyer's Catalog of Fishes: References. https://researcharchive.calacademy.org/research/ichthyology/catalog/fishcatmain.asp
}
\author{
Samuel R. Borstein, Brian C. O'Meara
}
