% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_col_names.R
\name{change_col_name}
\alias{change_col_name}
\title{Change one column name of a data.frame}
\usage{
change_col_name(x, old_name, new_name, warning = FALSE)
}
\arguments{
\item{x}{data.frame with a column name to change}

\item{old_name}{name (as character string) of column in \code{x}
that should be changed.}

\item{new_name}{new name (as character string) to use instead of \code{old_name}}

\item{warning}{should a warning be given if a name clash occours (\code{FALSE} by default)}
}
\value{
The same data.frame but with one column named changed.
(Note that the output might have one column less if dropped after name clash.)
}
\description{
A data.frame can, by definition, have non unique column names.
To change a column name to a new name that is already present in the data.frame
might therefore lead to undesiered results. This function handles this problem
by dropping the original column cousing the name clash.
}
\examples{
ab <- ba <- data.frame(a = letters[1:10], b = 1:10)

# One "traditional" way to change a column name
names(ab)[names(ab) == "a"] <- "b"
names(ab)
ab$b # Returns the first column with name "b"

# Using change_col_names instead:
change_col_name(ba, "a", "b")

}

