/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import org.jmol.g3d.Awt3D;
import org.jmol.g3d.Swing3D;

abstract class Platform3D {
    int windowWidth;
    int windowHeight;
    int windowSize;
    int bufferWidth;
    int bufferHeight;
    int bufferSize;
    Image imagePixelBuffer;
    int[] pBuffer;
    int[] zBuffer;
    int argbBackground;
    int widthOffscreen;
    int heightOffscreen;
    Image imageOffscreen;
    Graphics gOffscreen;
    static final boolean forcePlatformAWT = false;
    static final boolean desireClearingThread = false;
    boolean useClearingThread = true;
    ClearingThread clearingThread;
    static final int ZBUFFER_BACKGROUND = Integer.MAX_VALUE;

    Platform3D() {
    }

    static Platform3D createInstance(Component awtComponent) {
        boolean jvm12orGreater = System.getProperty("java.version").compareTo("1.2") >= 0;
        boolean useSwing = jvm12orGreater;
        Platform3D platform = useSwing ? Platform3D.allocateSwing3D() : new Awt3D(awtComponent);
        platform.initialize(false & useSwing);
        return platform;
    }

    private static Platform3D allocateSwing3D() {
        return new Swing3D();
    }

    final void initialize(boolean useClearingThread) {
        this.useClearingThread = useClearingThread;
        if (useClearingThread) {
            this.clearingThread = new ClearingThread();
            this.clearingThread.start();
        }
    }

    abstract Image allocateImage();

    void allocateBuffers(int width, int height, boolean tFsaa4) {
        this.windowWidth = width;
        this.windowHeight = height;
        this.windowSize = width * height;
        if (tFsaa4) {
            this.bufferWidth = width * 2;
            this.bufferHeight = height * 2;
        } else {
            this.bufferWidth = width;
            this.bufferHeight = height;
        }
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.zBuffer = new int[this.bufferSize];
        this.pBuffer = new int[this.bufferSize];
        this.imagePixelBuffer = this.allocateImage();
    }

    void releaseBuffers() {
        this.bufferSize = -1;
        this.bufferHeight = -1;
        this.bufferWidth = -1;
        this.windowHeight = -1;
        this.windowWidth = -1;
        if (this.imagePixelBuffer != null) {
            this.imagePixelBuffer.flush();
            this.imagePixelBuffer = null;
        }
        this.pBuffer = null;
        this.zBuffer = null;
    }

    void setBackground(int argbBackground) {
        if (this.argbBackground != argbBackground) {
            this.argbBackground = argbBackground;
            if (this.useClearingThread) {
                this.clearingThread.notifyBackgroundChange(argbBackground);
            }
        }
    }

    boolean hasContent() {
        int i = this.bufferSize;
        while (--i >= 0) {
            if (this.zBuffer[i] == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    void clearScreenBuffer(int argbBackground) {
        int i = this.bufferSize;
        while (--i >= 0) {
            this.zBuffer[i] = Integer.MAX_VALUE;
            this.pBuffer[i] = argbBackground;
        }
    }

    final void obtainScreenBuffer() {
        if (this.useClearingThread) {
            this.clearingThread.obtainBufferForClient();
        } else {
            this.clearScreenBuffer(this.argbBackground);
        }
    }

    final void clearScreenBufferThreaded() {
        if (this.useClearingThread) {
            this.clearingThread.releaseBufferForClearing();
        }
    }

    void notifyEndOfRendering() {
    }

    abstract Image allocateOffscreenImage(int var1, int var2);

    abstract Graphics getGraphics(Image var1);

    void checkOffscreenSize(int width, int height) {
        if (width <= this.widthOffscreen && height <= this.heightOffscreen) {
            return;
        }
        if (this.imageOffscreen != null) {
            this.gOffscreen.dispose();
            this.imageOffscreen.flush();
        }
        if (width > this.widthOffscreen) {
            this.widthOffscreen = width + 63 & 0xFFFFFFC0;
        }
        if (height > this.heightOffscreen) {
            this.heightOffscreen = height + 15 & 0xFFFFFFF0;
        }
        this.imageOffscreen = this.allocateOffscreenImage(this.widthOffscreen, this.heightOffscreen);
        this.gOffscreen = this.getGraphics(this.imageOffscreen);
    }

    class ClearingThread
    extends Thread
    implements Runnable {
        boolean bufferHasBeenCleared = false;
        boolean clientHasBuffer = false;

        ClearingThread() {
        }

        synchronized void notifyBackgroundChange(int argbBackground) {
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void obtainBufferForClient() {
            while (!this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.clientHasBuffer = true;
        }

        synchronized void releaseBufferForClearing() {
            this.clientHasBuffer = false;
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void waitForClientRelease() {
            while (this.clientHasBuffer || this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void notifyBufferReady() {
            this.bufferHasBeenCleared = true;
            this.notify();
        }

        public void run() {
            while (true) {
                int bg;
                this.waitForClientRelease();
                do {
                    bg = Platform3D.this.argbBackground;
                    Platform3D.this.clearScreenBuffer(bg);
                } while (bg != Platform3D.this.argbBackground);
                this.notifyBufferReady();
            }
        }
    }
}

