/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.openscience.cdk.applications.jchempaint.JChemPaintEditorPanel;

public class InfoDialog
extends JFrame {
    private static final long serialVersionUID = 8815234087125352307L;
    private JEditorPane infoPane;

    public InfoDialog() {
        super("JChemPaint License");
        this.createDialog();
        this.displayContent();
        this.pack();
        this.setVisible(true);
    }

    private void createDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.white);
        Border lb = BorderFactory.createLineBorder(Color.white, 5);
        JTextArea jtf1 = new JTextArea("Information about JChemPaint");
        jtf1.setBorder(lb);
        jtf1.setEditable(false);
        this.infoPane = new JEditorPane();
        this.infoPane.setEditable(false);
        this.infoPane.setBorder(lb);
        this.infoPane.revalidate();
        JScrollPane scrollPane = new JScrollPane(this.infoPane);
        scrollPane.setPreferredSize(new Dimension(400, 350));
        this.setTitle("Information");
        this.getContentPane().add("Center", scrollPane);
        this.getContentPane().add("North", jtf1);
    }

    private void displayContent() {
        StringBuffer content = new StringBuffer();
        content.append("<html>\n");
        this.addJavaEnvironmentInfo(content);
        this.addDictionariesInfo(content);
        content.append("</html>\n");
        this.infoPane.setContentType("text/html");
        this.infoPane.setText(content.toString());
        this.infoPane.revalidate();
    }

    private void addJavaEnvironmentInfo(StringBuffer content) {
        content.append("<h3>Java Environment</h3>\n");
        content.append("<p><ul>\n");
        content.append("<li>Virtual Machine name: " + System.getProperty("java.vm.name"));
        content.append("<li>version: " + System.getProperty("java.vm.version"));
        content.append("<li>vendor: " + System.getProperty("java.vm.vendor"));
        content.append("</ul>\n<p><ul>\n");
        content.append("<li>Runtime Environment version: " + System.getProperty("java.version"));
        content.append("<li>vendor: " + System.getProperty("java.vendor"));
        content.append("</ul>\n<p><ul>\n");
        content.append("<li>Operating System: " + System.getProperty("os.name"));
        content.append("<li>architecture: " + System.getProperty("os.arch"));
        content.append("<li>version: " + System.getProperty("os.version"));
        content.append("</ul>\n");
    }

    private void addDictionariesInfo(StringBuffer content) {
        content.append("<h3>Dictionaries</h3>\n");
        String[] dicts = JChemPaintEditorPanel.getDictionaryDatabase().getDictionaryNames();
        if (dicts.length > 0) {
            content.append("<p>Loaded dictionaries: ");
            for (int i = 0; i < dicts.length; ++i) {
                content.append(dicts[i] + " ");
            }
        } else {
            content.append("<p>No dictionaries are loaded.");
        }
    }
}

