/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.CrystClustFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.math.FortranFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.CrystClustReaderTest")
public class CrystClustReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CrystClustReader.class);

    public CrystClustReader() {
    }

    public CrystClustReader(Reader input) {
        this();
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public CrystClustReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return CrystClustFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public IChemObject read(IChemObject object) throws CDKException {
        if (object instanceof IChemFile) {
            IChemFile cf = this.readChemFile((IChemFile)object);
            return cf;
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private IChemFile readChemFile(IChemFile file) throws CDKException {
        IChemSequence seq = file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel model = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        ICrystal crystal = null;
        int lineNumber = 0;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                logger.debug(lineNumber++ + ": ", line);
                if (line.startsWith("frame:")) {
                    logger.debug("found new frame");
                    model = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    crystal = file.getBuilder().newInstance(ICrystal.class, new Object[0]);
                    logger.debug("reading spacegroup");
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    crystal.setSpaceGroup(line);
                    logger.debug("reading unit cell axes");
                    Vector3d axis = new Vector3d();
                    logger.debug("parsing A: ");
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.x = FortranFormat.atof(line);
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.y = FortranFormat.atof(line);
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.z = FortranFormat.atof(line);
                    crystal.setA(axis);
                    axis = new Vector3d();
                    logger.debug("parsing B: ");
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.x = FortranFormat.atof(line);
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.y = FortranFormat.atof(line);
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.z = FortranFormat.atof(line);
                    crystal.setB(axis);
                    axis = new Vector3d();
                    logger.debug("parsing C: ");
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.x = FortranFormat.atof(line);
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.y = FortranFormat.atof(line);
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    axis.z = FortranFormat.atof(line);
                    crystal.setC(axis);
                    logger.debug("Crystal: ", crystal);
                    Vector3d a = crystal.getA();
                    Vector3d b = crystal.getB();
                    Vector3d c = crystal.getC();
                    logger.debug("Reading number of atoms");
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    int atomsToRead = Integer.parseInt(line);
                    logger.debug("Reading no molecules in assym unit cell");
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                    int Z = Integer.parseInt(line);
                    crystal.setZ(Z);
                    for (int i = 1; i <= atomsToRead; ++i) {
                        Point3d cart = new Point3d();
                        line = this.input.readLine();
                        logger.debug(lineNumber++ + ": ", line);
                        String symbol = line.substring(0, line.indexOf(":"));
                        double charge = Double.parseDouble(line.substring(line.indexOf(":") + 1));
                        line = this.input.readLine();
                        logger.debug(lineNumber++ + ": ", line);
                        cart.x = Double.parseDouble(line);
                        line = this.input.readLine();
                        logger.debug(lineNumber++ + ": ", line);
                        cart.y = Double.parseDouble(line);
                        line = this.input.readLine();
                        logger.debug(lineNumber++ + ": ", line);
                        cart.z = Double.parseDouble(line);
                        IAtom atom = file.getBuilder().newInstance(IAtom.class, symbol);
                        atom.setCharge(charge);
                        Point3d frac = CrystalGeometryTools.cartesianToFractional(a, b, c, cart);
                        atom.setFractionalPoint3d(frac);
                        crystal.addAtom(atom);
                        logger.debug("Added atom: ", atom);
                    }
                    model.setCrystal(crystal);
                    seq.addChemModel(model);
                    continue;
                }
                logger.debug("Format seems broken. Skipping these lines:");
                while (!line.startsWith("frame:") && this.input.ready() && line != null) {
                    line = this.input.readLine();
                    logger.debug(lineNumber++ + ": ", line);
                }
                logger.debug("Ok, resynched: found new frame");
            }
            file.addChemSequence(seq);
        }
        catch (Exception exception) {
            String message = "Error while parsing CrystClust file: " + exception.getMessage();
            logger.error(message);
            logger.debug(exception);
            throw new CDKException(message, exception);
        }
        return file;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

