/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLMiniReasoner
extends GenericRuleReasoner
implements Reasoner {
    protected static final String MINI_RULE_FILE = "etc/owl-fb-mini.rules";
    protected static List<Rule> miniRuleSet;

    public static List<Rule> loadRules() {
        if (miniRuleSet == null) {
            miniRuleSet = OWLMiniReasoner.loadRules(MINI_RULE_FILE);
        }
        return miniRuleSet;
    }

    public OWLMiniReasoner(ReasonerFactory factory) {
        super(OWLMiniReasoner.loadRules(), factory);
        this.setOWLTranslation(true);
        this.setMode(HYBRID);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        InfGraph graph = super.bind(data);
        ((FBRuleInfGraph)graph).setDatatypeRangeValidation(true);
        return graph;
    }

    @Override
    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }
}

