/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugIsotope
extends Isotope
implements IIsotope {
    private static final long serialVersionUID = -2659188100080921299L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugIsotope.class);

    public DebugIsotope(String elementSymbol) {
        super(elementSymbol);
        this.logger.debug("Instantiated a DebugIsotope.");
    }

    public DebugIsotope(int atomicNumber, String elementSymbol, int massNumber, double exactMass, double abundance) {
        super(atomicNumber, elementSymbol, massNumber, exactMass, abundance);
        this.logger.debug("Instantiated a DebugIsotope.");
    }

    public DebugIsotope(int atomicNumber, String elementSymbol, double exactMass, double abundance) {
        super(atomicNumber, elementSymbol, exactMass, abundance);
        this.logger.debug("Instantiated a DebugIsotope.");
    }

    public DebugIsotope(String elementSymbol, int massNumber) {
        super(elementSymbol, massNumber);
        this.logger.debug("Instantiated a DebugIsotope.");
    }

    public DebugIsotope(IElement element) {
        super(element);
        this.logger.debug("Instantiated a DebugIsotope from element: ", element);
    }

    @Override
    public Integer getAtomicNumber() {
        this.logger.debug("Getting atomic number: ", super.getAtomicNumber());
        return super.getAtomicNumber();
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        this.logger.debug("Setting atomic number: ", atomicNumber);
        super.setAtomicNumber(atomicNumber);
    }

    @Override
    public String getSymbol() {
        this.logger.debug("Getting symbol: ", super.getSymbol());
        return super.getSymbol();
    }

    @Override
    public void setSymbol(String symbol) {
        this.logger.debug("Setting symbol: ", symbol);
        super.setSymbol(symbol);
    }

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public Object getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        this.logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.setProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        this.logger.debug("Setting natural abundance: ", naturalAbundance);
        super.setNaturalAbundance(naturalAbundance);
    }

    @Override
    public void setExactMass(Double exactMass) {
        this.logger.debug("Setting exact mass: ", exactMass);
        super.setExactMass(exactMass);
    }

    @Override
    public Double getNaturalAbundance() {
        this.logger.debug("Getting natural abundance: ", super.getNaturalAbundance());
        return super.getNaturalAbundance();
    }

    @Override
    public Double getExactMass() {
        this.logger.debug("Getting exact mass: ", super.getExactMass());
        return super.getExactMass();
    }

    @Override
    public Integer getMassNumber() {
        this.logger.debug("Getting mass number: ", super.getMassNumber());
        return super.getMassNumber();
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        this.logger.debug("Setting mass number: ", massNumber);
        super.setMassNumber(massNumber);
    }
}

