/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.PeriodicTablePositionDescriptorTest")
public class PeriodicTablePositionDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] names = new String[]{"periodicTablePosition"};
    public Map<String, Integer> periodicTable;

    public PeriodicTablePositionDescriptor() {
        if (this.periodicTable == null) {
            this.periodicTable = new Hashtable<String, Integer>();
            this.periodicTable.put("H", 1);
            this.periodicTable.put("Li", 2);
            this.periodicTable.put("Be", 2);
            this.periodicTable.put("B", 2);
            this.periodicTable.put("C", 2);
            this.periodicTable.put("N", 2);
            this.periodicTable.put("O", 2);
            this.periodicTable.put("F", 2);
            this.periodicTable.put("Na", 3);
            this.periodicTable.put("Mg", 3);
            this.periodicTable.put("Al", 3);
            this.periodicTable.put("Si", 3);
            this.periodicTable.put("P", 3);
            this.periodicTable.put("S", 3);
            this.periodicTable.put("Cl", 3);
            this.periodicTable.put("K", 4);
            this.periodicTable.put("Ca", 4);
            this.periodicTable.put("Ga", 4);
            this.periodicTable.put("Ge", 4);
            this.periodicTable.put("As", 4);
            this.periodicTable.put("Se", 4);
            this.periodicTable.put("Br", 4);
            this.periodicTable.put("Rb", 5);
            this.periodicTable.put("Sr", 5);
            this.periodicTable.put("In", 5);
            this.periodicTable.put("Sn", 5);
            this.periodicTable.put("Sb", 5);
            this.periodicTable.put("Te", 5);
            this.periodicTable.put("I", 5);
            this.periodicTable.put("Cs", 6);
            this.periodicTable.put("Ba", 6);
            this.periodicTable.put("Tl", 6);
            this.periodicTable.put("Pb", 6);
            this.periodicTable.put("Bi", 6);
            this.periodicTable.put("Po", 6);
            this.periodicTable.put("At", 6);
            this.periodicTable.put("Fr", 7);
            this.periodicTable.put("Ra", 7);
        }
    }

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#period", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        String symbol = atom.getSymbol();
        int period = this.periodicTable.get(symbol);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(period), names);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

