/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class AtomTetrahedralLigandPlacer3D {
    private Map pSet = null;
    public static final double DEFAULT_BOND_LENGTH_H = 1.0;
    public static final double TETRAHEDRAL_ANGLE = 2.0 * Math.acos(1.0 / Math.sqrt(3.0));
    private static final double SP2_ANGLE = 2.0943951023931953;
    private static final double SP_ANGLE = Math.PI;
    static final Vector3d XV = new Vector3d(1.0, 0.0, 0.0);
    static final Vector3d YV = new Vector3d(0.0, 1.0, 0.0);

    AtomTetrahedralLigandPlacer3D() {
    }

    public void setParameterSet(Map moleculeParameter) {
        this.pSet = moleculeParameter;
    }

    public void add3DCoordinatesForSinglyBondedLigands(IAtomContainer atomContainer) throws CDKException {
        IAtom refAtom = null;
        IAtom atomC = null;
        int nwanted = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            refAtom = atomContainer.getAtom(i);
            if (refAtom.getSymbol().equals("H") || !this.hasUnsetNeighbour(refAtom, atomContainer)) continue;
            IAtomContainer noCoords = this.getUnsetAtomsInAtomContainer(refAtom, atomContainer);
            IAtomContainer withCoords = this.getPlacedAtomsInAtomContainer(refAtom, atomContainer);
            if (withCoords.getAtomCount() > 0) {
                atomC = this.getPlacedHeavyAtomInAtomContainer(withCoords.getAtom(0), refAtom, atomContainer);
            }
            nwanted = refAtom.getFormalNeighbourCount() == 0 && refAtom.getSymbol().equals("C") ? noCoords.getAtomCount() : (refAtom.getFormalNeighbourCount() == 0 && !refAtom.getSymbol().equals("C") ? 4 : refAtom.getFormalNeighbourCount() - withCoords.getAtomCount());
            Point3d[] newPoints = this.get3DCoordinatesForLigands(refAtom, noCoords, withCoords, atomC, nwanted, 1.0, -1.0);
            for (int j = 0; j < noCoords.getAtomCount(); ++j) {
                IAtom ligand = noCoords.getAtom(j);
                Point3d newPoint = this.rescaleBondLength(refAtom, ligand, newPoints[j]);
                ligand.setPoint3d(newPoint);
                ligand.setFlag(1, true);
            }
            noCoords.removeAllElements();
            withCoords.removeAllElements();
        }
    }

    public Point3d rescaleBondLength(IAtom atom1, IAtom atom2, Point3d point2) {
        double distance;
        Point3d point1 = atom1.getPoint3d();
        Double d1 = atom1.getCovalentRadius();
        Double d2 = atom2.getCovalentRadius();
        double d = distance = d1 == null || d2 == null ? 1.0 : d1 + d2;
        if (this.pSet != null) {
            distance = this.getDistanceValue(atom1.getAtomTypeName(), atom2.getAtomTypeName());
        }
        Vector3d vect = new Vector3d((Tuple3d)point2);
        vect.sub((Tuple3d)point1);
        vect.normalize();
        vect.scale(distance);
        Point3d newPoint = new Point3d(point1);
        newPoint.add((Tuple3d)vect);
        return newPoint;
    }

    public Point3d[] get3DCoordinatesForLigands(IAtom refAtom, IAtomContainer noCoords, IAtomContainer withCoords, IAtom atomC, int nwanted, double length, double angle) throws CDKException {
        Point3d[] newPoints = new Point3d[1];
        if (noCoords.getAtomCount() == 0 && withCoords.getAtomCount() == 0) {
            return newPoints;
        }
        if (withCoords.getAtomCount() > 3) {
            return newPoints;
        }
        IBond.Order refMaxBondOrder = refAtom.getMaxBondOrder();
        if (refAtom.getFormalNeighbourCount() != 1) {
            if (refAtom.getFormalNeighbourCount() == 2 || refMaxBondOrder == IBond.Order.TRIPLE) {
                if (angle == -1.0) {
                    angle = Math.PI;
                }
                newPoints[0] = this.get3DCoordinatesForSPLigands(refAtom, withCoords, length, angle);
            } else {
                if (refAtom.getFormalNeighbourCount() == 3 || refMaxBondOrder == IBond.Order.DOUBLE) {
                    if (angle == -1.0) {
                        angle = 2.0943951023931953;
                    }
                    try {
                        newPoints = this.get3DCoordinatesForSP2Ligands(refAtom, noCoords, withCoords, atomC, length, angle);
                    }
                    catch (Exception ex1) {
                        throw new CDKException("Cannot place sp2 substituents\n" + ex1.getMessage(), (Throwable)ex1);
                    }
                }
                try {
                    newPoints = this.get3DCoordinatesForSP3Ligands(refAtom, noCoords, withCoords, atomC, nwanted, length, angle);
                }
                catch (Exception ex1) {
                    throw new CDKException("Cannot place sp3 substituents\n" + ex1.getMessage(), (Throwable)ex1);
                }
            }
        }
        return newPoints;
    }

    public Point3d get3DCoordinatesForSPLigands(IAtom refAtom, IAtomContainer withCoords, double length, double angle) {
        Vector3d ca = new Vector3d((Tuple3d)refAtom.getPoint3d());
        ca.sub((Tuple3d)withCoords.getAtom(0).getPoint3d());
        ca.normalize();
        ca.scale(length);
        Point3d newPoint = new Point3d(refAtom.getPoint3d());
        newPoint.add((Tuple3d)ca);
        return newPoint;
    }

    public Point3d[] get3DCoordinatesForSP2Ligands(IAtom refAtom, IAtomContainer noCoords, IAtomContainer withCoords, IAtom atomC, double length, double angle) {
        Point3d[] newPoints = new Point3d[1];
        if (angle < 0.0) {
            angle = 2.0943951023931953;
        }
        if (withCoords.getAtomCount() >= 2) {
            newPoints[0] = this.calculate3DCoordinatesSP2_1(refAtom.getPoint3d(), withCoords.getAtom(0).getPoint3d(), withCoords.getAtom(1).getPoint3d(), length, -1.0 * angle);
        } else if (withCoords.getAtomCount() <= 1) {
            newPoints = this.calculate3DCoordinatesSP2_2(refAtom.getPoint3d(), withCoords.getAtom(0).getPoint3d(), atomC != null ? atomC.getPoint3d() : null, length, angle);
        }
        return newPoints;
    }

    public Point3d[] get3DCoordinatesForSP3Ligands(IAtom refAtom, IAtomContainer noCoords, IAtomContainer withCoords, IAtom atomC, int nwanted, double length, double angle) {
        Point3d[] newPoints = new Point3d[]{};
        Point3d aPoint = refAtom.getPoint3d();
        int nwithCoords = withCoords.getAtomCount();
        if (angle < 0.0) {
            angle = TETRAHEDRAL_ANGLE;
        }
        if (nwithCoords == 0) {
            newPoints = this.calculate3DCoordinates0(refAtom.getPoint3d(), nwanted, length);
        } else if (nwithCoords == 1) {
            newPoints = this.calculate3DCoordinates1(aPoint, withCoords.getAtom(0).getPoint3d(), atomC != null ? atomC.getPoint3d() : null, nwanted, length, angle);
        } else if (nwithCoords == 2) {
            Point3d bPoint = withCoords.getAtom(0).getPoint3d();
            Point3d cPoint = withCoords.getAtom(1).getPoint3d();
            newPoints = this.calculate3DCoordinates2(aPoint, bPoint, cPoint, nwanted, length, angle);
        } else if (nwithCoords == 3) {
            Point3d bPoint = withCoords.getAtom(0).getPoint3d();
            Point3d cPoint = withCoords.getAtom(1).getPoint3d();
            newPoints = new Point3d[1];
            Point3d dPoint = withCoords.getAtom(2).getPoint3d();
            newPoints[0] = this.calculate3DCoordinates3(aPoint, bPoint, cPoint, dPoint, length);
        }
        return newPoints;
    }

    public Point3d[] calculate3DCoordinates0(Point3d aPoint, int nwanted, double length) {
        Point3d[] points = new Point3d[]{};
        if (nwanted == 1) {
            points = new Point3d[]{new Point3d(aPoint)};
            points[0].add((Tuple3d)new Vector3d(length, 0.0, 0.0));
        } else if (nwanted == 2) {
            points = new Point3d[2];
            points[0] = new Point3d(aPoint);
            points[0].add((Tuple3d)new Vector3d(length, 0.0, 0.0));
            points[1] = new Point3d(aPoint);
            points[1].add((Tuple3d)new Vector3d(-length, 0.0, 0.0));
        } else if (nwanted == 3) {
            points = new Point3d[3];
            points[0] = new Point3d(aPoint);
            points[0].add((Tuple3d)new Vector3d(length, 0.0, 0.0));
            points[1] = new Point3d(aPoint);
            points[1].add((Tuple3d)new Vector3d(-length * 0.5, -length * 0.5 * Math.sqrt(3.0), 0.0));
            points[2] = new Point3d(aPoint);
            points[2].add((Tuple3d)new Vector3d(-length * 0.5, length * 0.5 * Math.sqrt(3.0), 0.0));
        } else if (nwanted == 4) {
            points = new Point3d[4];
            double dx = length / Math.sqrt(3.0);
            points[0] = new Point3d(aPoint);
            points[0].add((Tuple3d)new Vector3d(dx, dx, dx));
            points[1] = new Point3d(aPoint);
            points[1].add((Tuple3d)new Vector3d(dx, -dx, -dx));
            points[2] = new Point3d(aPoint);
            points[2].add((Tuple3d)new Vector3d(-dx, -dx, dx));
            points[3] = new Point3d(aPoint);
            points[3].add((Tuple3d)new Vector3d(-dx, dx, -dx));
        }
        return points;
    }

    public Point3d[] calculate3DCoordinates1(Point3d aPoint, Point3d bPoint, Point3d cPoint, int nwanted, double length, double angle) {
        Point3d[] points = new Point3d[nwanted];
        Vector3d ba = new Vector3d((Tuple3d)aPoint);
        ba.sub((Tuple3d)bPoint);
        ba.normalize();
        if (cPoint == null) {
            Vector3d cVector = this.getNonColinearVector(ba);
            cPoint = new Point3d((Tuple3d)cVector);
        }
        Vector3d cb = new Vector3d((Tuple3d)bPoint);
        cb.sub((Tuple3d)cPoint);
        cb.normalize();
        double cbdotba = cb.dot(ba);
        if (cbdotba > 0.999999) {
            Vector3d cVector = this.getNonColinearVector(ba);
            cPoint = new Point3d((Tuple3d)cVector);
            cb = new Vector3d((Tuple3d)bPoint);
            cb.sub((Tuple3d)cPoint);
        }
        Vector3d cbxba = new Vector3d();
        cbxba.cross(cb, ba);
        cbxba.normalize();
        Vector3d ax = new Vector3d();
        ax.cross(cbxba, ba);
        ax.normalize();
        double drot = Math.PI * 2 / (double)nwanted;
        for (int i = 0; i < nwanted; ++i) {
            double rot = (double)i * drot;
            points[i] = new Point3d(aPoint);
            Vector3d vx = new Vector3d(ba);
            vx.scale(-Math.cos(angle) * length);
            Vector3d vy = new Vector3d(ax);
            vy.scale(Math.cos(rot) * length);
            Vector3d vz = new Vector3d(cbxba);
            vz.scale(Math.sin(rot) * length);
            points[i].add((Tuple3d)vx);
            points[i].add((Tuple3d)vy);
            points[i].add((Tuple3d)vz);
        }
        return points;
    }

    public Point3d[] calculate3DCoordinates2(Point3d aPoint, Point3d bPoint, Point3d cPoint, int nwanted, double length, double angle) {
        Point3d[] newPoints = new Point3d[]{};
        double ang2 = angle / 2.0;
        Vector3d ba = new Vector3d((Tuple3d)aPoint);
        ba.sub((Tuple3d)bPoint);
        Vector3d ca = new Vector3d((Tuple3d)aPoint);
        ca.sub((Tuple3d)cPoint);
        Vector3d baxca = new Vector3d();
        baxca.cross(ba, ca);
        if (!(baxca.length() < 1.0E-8)) {
            if (nwanted == 1) {
                newPoints = new Point3d[1];
                Vector3d ax = new Vector3d(ba);
                ax.add((Tuple3d)ca);
                ax.normalize();
                ax.scale(length);
                newPoints[0] = new Point3d(aPoint);
                newPoints[0].add((Tuple3d)ax);
            } else if (nwanted >= 2) {
                newPoints = new Point3d[2];
                Vector3d ax = new Vector3d(ba);
                ax.add((Tuple3d)ca);
                ax.normalize();
                baxca.normalize();
                baxca.scale(Math.sin(ang2) * length);
                ax.scale(Math.cos(ang2) * length);
                newPoints[0] = new Point3d(aPoint);
                newPoints[0].add((Tuple3d)ax);
                newPoints[0].add((Tuple3d)baxca);
                newPoints[1] = new Point3d(aPoint);
                newPoints[1].add((Tuple3d)ax);
                newPoints[1].sub((Tuple3d)baxca);
            }
        }
        baxca = null;
        ba = null;
        ca = null;
        return newPoints;
    }

    public Point3d calculate3DCoordinates3(Point3d aPoint, Point3d bPoint, Point3d cPoint, Point3d dPoint, double length) {
        Vector3d bc = new Vector3d((Tuple3d)bPoint);
        bc.sub((Tuple3d)cPoint);
        Vector3d dc = new Vector3d((Tuple3d)dPoint);
        dc.sub((Tuple3d)cPoint);
        Vector3d ca = new Vector3d((Tuple3d)cPoint);
        ca.sub((Tuple3d)aPoint);
        Vector3d n1 = new Vector3d();
        Vector3d n2 = new Vector3d();
        n1.cross(bc, dc);
        n1.normalize();
        n1.scale(length);
        Vector3d ax = new Vector3d((Tuple3d)aPoint);
        ax.add((Tuple3d)n1);
        ax.sub((Tuple3d)aPoint);
        Vector3d ax2 = new Vector3d((Tuple3d)aPoint);
        ax2.add((Tuple3d)n2);
        ax2.sub((Tuple3d)aPoint);
        Point3d point = new Point3d(aPoint);
        double dotProduct = ca.dot(ax);
        double angle = Math.acos(dotProduct / (ax.length() * ca.length()));
        if (angle < 1.5) {
            n2.cross(dc, bc);
            n2.normalize();
            n2.scale(length);
            point.add((Tuple3d)n2);
        } else {
            point.add((Tuple3d)n1);
        }
        bc = null;
        dc = null;
        ca = null;
        n1 = null;
        n2 = null;
        return point;
    }

    public Point3d calculate3DCoordinatesSP2_1(Point3d aPoint, Point3d bPoint, Point3d cPoint, double length, double angle) {
        Vector3d ba = new Vector3d((Tuple3d)bPoint);
        ba.sub((Tuple3d)aPoint);
        Vector3d ca = new Vector3d((Tuple3d)cPoint);
        ca.sub((Tuple3d)aPoint);
        Vector3d n1 = new Vector3d();
        n1.cross(ba, ca);
        n1.normalize();
        Vector3d n2 = AtomTetrahedralLigandPlacer3D.rotate(ba, n1, angle);
        n2.normalize();
        n2.scale(length);
        Point3d point = new Point3d(aPoint);
        point.add((Tuple3d)n2);
        n1 = null;
        n2 = null;
        ba = null;
        ca = null;
        return point;
    }

    public Point3d[] calculate3DCoordinatesSP2_2(Point3d aPoint, Point3d bPoint, Point3d cPoint, double length, double angle) {
        Vector3d ca = new Vector3d();
        Point3d[] newPoints = new Point3d[2];
        Vector3d ba = new Vector3d((Tuple3d)bPoint);
        ba.sub((Tuple3d)aPoint);
        if (cPoint != null) {
            ca.x = cPoint.x - aPoint.x;
            ca.y = cPoint.y - aPoint.y;
            ca.z = cPoint.z - aPoint.z;
        } else {
            ca.x = -1.0 * ba.x;
            ca.y = -1.0 * ba.y;
            ca.z = -1.5 * ba.z;
        }
        Vector3d crossProduct = new Vector3d();
        crossProduct.cross(ba, ca);
        Vector3d n1 = AtomTetrahedralLigandPlacer3D.rotate(ba, crossProduct, 2.0 * angle);
        n1.normalize();
        n1.scale(length);
        newPoints[0] = new Point3d(aPoint);
        newPoints[0].add((Tuple3d)n1);
        Vector3d n2 = AtomTetrahedralLigandPlacer3D.rotate(n1, ba, Math.PI);
        n2.normalize();
        n2.scale(length);
        newPoints[1] = new Point3d(aPoint);
        newPoints[1].add((Tuple3d)n2);
        n1 = null;
        n2 = null;
        ba = null;
        ca = null;
        return newPoints;
    }

    private Vector3d getNonColinearVector(Vector3d ab) {
        Vector3d cr = new Vector3d();
        cr.cross(ab, XV);
        if (cr.length() > 1.0E-5) {
            return XV;
        }
        return YV;
    }

    public static Vector3d rotate(Vector3d vector, Vector3d axis, double angle) {
        Matrix3d rotate = new Matrix3d();
        rotate.set(new AxisAngle4d(axis.x, axis.y, axis.z, angle));
        Vector3d result = new Vector3d();
        rotate.transform((Tuple3d)vector, (Tuple3d)result);
        return result;
    }

    private double getDistanceValue(String id1, String id2) {
        String dkey = "";
        if (this.pSet.containsKey("bond" + id1 + ";" + id2)) {
            dkey = "bond" + id1 + ";" + id2;
        } else if (this.pSet.containsKey("bond" + id2 + ";" + id1)) {
            dkey = "bond" + id2 + ";" + id1;
        } else {
            return 1.0;
        }
        return (Double)((List)this.pSet.get(dkey)).get(0);
    }

    public double getAngleValue(String id1, String id2, String id3) {
        String akey = "";
        if (this.pSet.containsKey("angle" + id1 + ";" + id2 + ";" + id3)) {
            akey = "angle" + id1 + ";" + id2 + ";" + id3;
        } else if (this.pSet.containsKey("angle" + id3 + ";" + id2 + ";" + id1)) {
            akey = "angle" + id3 + ";" + id2 + ";" + id1;
        } else if (this.pSet.containsKey("angle" + id2 + ";" + id1 + ";" + id3)) {
            akey = "angle" + id2 + ";" + id1 + ";" + id3;
        } else if (this.pSet.containsKey("angle" + id1 + ";" + id3 + ";" + id2)) {
            akey = "angle" + id1 + ";" + id3 + ";" + id2;
        } else if (this.pSet.containsKey("angle" + id3 + ";" + id1 + ";" + id2)) {
            akey = "angle" + id3 + ";" + id1 + ";" + id2;
        } else if (this.pSet.containsKey("angle" + id2 + ";" + id3 + ";" + id1)) {
            akey = "angle" + id2 + ";" + id3 + ";" + id1;
        } else {
            System.out.println("AngleKEYError:Unknown angle " + id1 + " " + id2 + " " + id3 + " take default angle:" + TETRAHEDRAL_ANGLE);
            return TETRAHEDRAL_ANGLE;
        }
        return (Double)((List)this.pSet.get(akey)).get(0);
    }

    public int makeStereocenter(Point3d atomA, IBond ax, Point3d atomB, Point3d atomC, Point3d[] branchPoints) {
        Vector3d b = new Vector3d(atomB.x - atomA.x, atomB.y - atomA.y, atomB.z - atomA.z);
        Vector3d c = new Vector3d(atomC.x - atomA.x, atomC.y - atomA.y, atomC.z - atomA.z);
        Vector3d n1 = new Vector3d();
        Vector3d n2 = null;
        n1.cross(b, c);
        n1.normalize();
        if (this.getSpatproduct(b, c, n1) >= 0.0 && ax.getStereo() != IBond.Stereo.UP_INVERTED) {
            n1.cross(c, b);
            n1.normalize();
        }
        double dotProduct = 0.0;
        for (int i = 0; i < branchPoints.length; ++i) {
            n2 = new Vector3d(branchPoints[0].x, branchPoints[0].y, branchPoints[0].z);
            dotProduct = n1.dot(n2);
            if (!(Math.acos(dotProduct / (n1.length() * n2.length())) < 1.6)) continue;
            return i;
        }
        return -1;
    }

    public double getSpatproduct(Vector3d a, Vector3d b, Vector3d c) {
        return c.x * (b.y * a.z - b.z * a.y) + c.y * (b.z * a.x - b.x * a.z) + c.z * (b.x * a.y - b.y * a.x);
    }

    public double getTorsionAngle(Point3d a, Point3d b, Point3d c, Point3d d) {
        Vector3d ab = new Vector3d(a.x - b.x, a.y - b.y, a.z - b.z);
        Vector3d cb = new Vector3d(c.x - b.x, c.y - b.y, c.z - b.z);
        Vector3d dc = new Vector3d(d.x - c.x, d.y - c.y, d.z - c.z);
        Vector3d bc = new Vector3d(b.x - c.x, b.y - c.y, b.z - c.z);
        Vector3d n1 = new Vector3d();
        Vector3d n2 = new Vector3d();
        n1.cross(ab, cb);
        if (this.getSpatproduct(ab, cb, n1) > 0.0) {
            n1.cross(cb, ab);
        }
        n1.normalize();
        n2.cross(dc, bc);
        if (this.getSpatproduct(dc, bc, n2) < 0.0) {
            n2.cross(bc, dc);
        }
        n2.normalize();
        return n1.dot(n2);
    }

    public IAtomContainer getPlacedAtomsInAtomContainer(IAtom atom, IAtomContainer ac) {
        List bonds = ac.getConnectedBondsList(atom);
        IAtomContainer connectedAtoms = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom connectedAtom = null;
        for (int i = 0; i < bonds.size(); ++i) {
            connectedAtom = ((IBond)bonds.get(i)).getConnectedAtom(atom);
            if (!connectedAtom.getFlag(1)) continue;
            connectedAtoms.addAtom(connectedAtom);
        }
        return connectedAtoms;
    }

    public IAtomContainer getUnsetAtomsInAtomContainer(IAtom atom, IAtomContainer ac) {
        List atoms = ac.getConnectedAtomsList(atom);
        IAtomContainer connectedAtoms = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom curAtom = (IAtom)atoms.get(i);
            if (curAtom.getFlag(1)) continue;
            connectedAtoms.addAtom(curAtom);
        }
        return connectedAtoms;
    }

    public boolean hasUnsetNeighbour(IAtom atom, IAtomContainer ac) {
        List atoms = ac.getConnectedAtomsList(atom);
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom curAtom = (IAtom)atoms.get(i);
            if (curAtom.getFlag(1)) continue;
            return true;
        }
        return false;
    }

    public IAtom getPlacedHeavyAtomInAtomContainer(IAtom atomA, IAtom atomB, IAtomContainer ac) {
        List atoms = ac.getConnectedAtomsList(atomA);
        IAtom atom = null;
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom curAtom = (IAtom)atoms.get(i);
            if (!curAtom.getFlag(1) || curAtom.getSymbol().equals("H") || curAtom == atomB) continue;
            return curAtom;
        }
        return atom;
    }
}

