/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.charges.IChargeCalculator;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.type.HeterolyticCleavagePBReaction;
import org.openscience.cdk.reaction.type.HeterolyticCleavageSBReaction;
import org.openscience.cdk.reaction.type.HyperconjugationReaction;
import org.openscience.cdk.reaction.type.SharingAnionReaction;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.StructureResonanceGenerator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class GasteigerPEPEPartialCharges
implements IChargeCalculator {
    private int MX_ITERATIONS = 8;
    private int MX_RESON = 50;
    private int STEP_SIZE = 5;
    private AtomTypeFactory factory;
    private static int ISCHANGEDFC = 1;
    private double fE = 1.1;
    private double fS = 0.37;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(GasteigerPEPEPartialCharges.class);

    public void setMaxGasteigerIters(int iters) {
        this.MX_ITERATIONS = iters;
    }

    public void setMaxResoStruc(int numbReson) {
        this.MX_RESON = numbReson;
    }

    public int getMaxGasteigerIters() {
        return this.MX_ITERATIONS;
    }

    public int getMaxResoStruc() {
        return this.MX_RESON;
    }

    public IAtomContainer assignGasteigerPiPartialCharges(IAtomContainer ac, boolean setCharge) throws Exception {
        int i;
        IAtomContainer iac;
        int i2;
        int j;
        int j2;
        int j3;
        int i3;
        boolean[] oldBondAromaticity = new boolean[ac.getBondCount()];
        boolean[] oldAtomAromaticity = new boolean[ac.getAtomCount()];
        for (i3 = 0; i3 < ac.getAtomCount(); ++i3) {
            oldAtomAromaticity[i3] = ac.getAtom(i3).getFlag(32);
        }
        for (i3 = 0; i3 < ac.getBondCount(); ++i3) {
            oldBondAromaticity[i3] = ac.getBond(i3).getFlag(32);
        }
        IAtomContainerSet setHI = null;
        for (j3 = 0; j3 < ac.getAtomCount(); ++j3) {
            ac.getAtom(j3).setCharge(0.0);
            ac.getAtom(j3).setFlag(ISCHANGEDFC, false);
        }
        for (j3 = 0; j3 < ac.getBondCount(); ++j3) {
            ac.getBond(j3).setFlag(ISCHANGEDFC, false);
        }
        StructureResonanceGenerator gR1 = new StructureResonanceGenerator();
        List<IReactionProcess> reactionList1 = gR1.getReactions();
        ArrayList<IParameterReact> paramList1 = new ArrayList<IParameterReact>();
        SetReactionCenter param = new SetReactionCenter();
        param.setParameter(Boolean.TRUE);
        paramList1.add(param);
        HeterolyticCleavagePBReaction reactionHCPB = new HeterolyticCleavagePBReaction();
        reactionHCPB.setParameterList(paramList1);
        reactionList1.add(new SharingAnionReaction());
        for (IReactionProcess reaction : reactionList1) {
            reaction.setParameterList(paramList1);
        }
        gR1.setReactions(reactionList1);
        StructureResonanceGenerator gR2 = new StructureResonanceGenerator();
        gR2.setMaximalStructures(this.MX_RESON);
        List<IReactionProcess> reactionList2 = gR2.getReactions();
        ArrayList<IParameterReact> paramList = new ArrayList<IParameterReact>();
        SetReactionCenter paramA = new SetReactionCenter();
        paramA.setParameter(Boolean.TRUE);
        paramList.add(paramA);
        reactionList2.add(new HeterolyticCleavagePBReaction());
        reactionList2.add(new SharingAnionReaction());
        for (IReactionProcess reaction : reactionList2) {
            reaction.setParameterList(paramList);
        }
        gR2.setReactions(reactionList2);
        StructureResonanceGenerator gRN = new StructureResonanceGenerator();
        IAtomContainerSet acSet = gRN.getContainers(this.removingFlagsAromaticity(ac));
        IAtomContainerSet iSet = ac.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        iSet.addAtomContainer(ac);
        if (acSet != null) {
            for (IAtomContainer container : acSet.atomContainers()) {
                ac = this.setFlags(container, ac, true);
                if (Aromaticity.cdkLegacy().apply(ac)) {
                    reactionList1.remove(reactionHCPB);
                } else {
                    reactionList1.add(reactionHCPB);
                }
                IAtomContainerSet a = gR1.getStructures(this.removingFlagsAromaticity(ac));
                if (a.getAtomContainerCount() > 1) {
                    for (j2 = 1; j2 < a.getAtomContainerCount(); ++j2) {
                        iSet.addAtomContainer(a.getAtomContainer(j2));
                    }
                }
                ac = this.setFlags(container, ac, false);
                for (int number = 0; number < ac.getBondCount(); ++number) {
                    IAtomContainer aa = this.setAntiFlags(container, ac, number, true);
                    if (aa == null) continue;
                    IAtomContainerSet ab = gR2.getStructures(aa);
                    if (ab.getAtomContainerCount() > 1) {
                        for (j = 1; j < ab.getAtomContainerCount(); ++j) {
                            iSet.addAtomContainer(ab.getAtomContainer(j));
                        }
                    }
                    ac = this.setAntiFlags(container, aa, number, false);
                }
            }
        }
        if ((setHI = this.getHyperconjugationInteractions(ac, iSet)) != null) {
            if (setHI.getAtomContainerCount() != 0) {
                iSet.add(setHI);
            }
            logger.debug("setHI: " + iSet.getAtomContainerCount());
        }
        if (iSet.getAtomContainerCount() < 2) {
            int i4;
            for (i4 = 0; i4 < ac.getAtomCount(); ++i4) {
                ac.getAtom(i4).setFlag(32, oldAtomAromaticity[i4]);
            }
            for (i4 = 0; i4 < ac.getBondCount(); ++i4) {
                ac.getBond(i4).setFlag(32, oldBondAromaticity[i4]);
            }
            return ac;
        }
        double[][] sumCharges = new double[iSet.getAtomContainerCount()][ac.getAtomCount()];
        for (i2 = 1; i2 < iSet.getAtomContainerCount(); ++i2) {
            iac = iSet.getAtomContainer(i2);
            for (j2 = 0; j2 < iac.getAtomCount(); ++j2) {
                sumCharges[i2][j2] = iac.getAtom(j2).getFormalCharge().intValue();
            }
        }
        for (i2 = 1; i2 < iSet.getAtomContainerCount(); ++i2) {
            iac = iSet.getAtomContainer(i2);
            int count = 0;
            for (int j4 = 0; j4 < ac.getAtomCount(); ++j4) {
                if (count >= 2 || sumCharges[i2][j4] == (double)ac.getAtom(j4).getFormalCharge().intValue()) continue;
                ac.getAtom(j4).setFlag(ISCHANGEDFC, true);
                iac.getAtom(j4).setFlag(ISCHANGEDFC, true);
                ++count;
            }
        }
        GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
        peoe.setMaxGasteigerIters(6.0);
        double[][] gasteigerFactors = this.assignPiFactors(iSet);
        double[] Wt = new double[iSet.getAtomContainerCount() - 1];
        for (i = 1; i < iSet.getAtomContainerCount(); ++i) {
            Wt[i - 1] = this.getTopologicalFactors(iSet.getAtomContainer(i), ac);
            logger.debug(", W:" + Wt[i - 1]);
            try {
                IAtomContainer acCloned = iSet.getAtomContainer(i).clone();
                acCloned = peoe.assignGasteigerMarsiliSigmaPartialCharges(acCloned, true);
                for (j = 0; j < acCloned.getAtomCount(); ++j) {
                    if (!iSet.getAtomContainer(i).getAtom(j).getFlag(ISCHANGEDFC)) continue;
                    gasteigerFactors[i][this.STEP_SIZE * j + j + 5] = acCloned.getAtom(j).getCharge();
                }
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new CDKException("Could not clone ac", e);
            }
        }
        for (int iter = 0; iter < this.MX_ITERATIONS; ++iter) {
            int k;
            for (k = 1; k < iSet.getAtomContainerCount(); ++k) {
                IAtomContainer iac2 = iSet.getAtomContainer(k);
                double[] electronegativity = new double[2];
                int count = 0;
                int atom1 = 0;
                int atom2 = 0;
                for (int j5 = 0; j5 < iac2.getAtomCount() && count != 2; ++j5) {
                    if (!iac2.getAtom(j5).getFlag(ISCHANGEDFC)) continue;
                    logger.debug("Atom: " + j5 + ", S:" + iac2.getAtom(j5).getSymbol() + ", C:" + iac2.getAtom(j5).getFormalCharge());
                    if (count == 0) {
                        atom1 = j5;
                    } else {
                        atom2 = j5;
                    }
                    double q1 = gasteigerFactors[k][this.STEP_SIZE * j5 + j5 + 5];
                    electronegativity[count] = gasteigerFactors[k][this.STEP_SIZE * j5 + j5 + 2] * q1 * q1 + gasteigerFactors[k][this.STEP_SIZE * j5 + j5 + 1] * q1 + gasteigerFactors[k][this.STEP_SIZE * j5 + j5];
                    logger.debug("e:" + electronegativity[count] + ",q1: " + q1 + ", c:" + gasteigerFactors[k][this.STEP_SIZE * j5 + j5 + 2] + ", b:" + gasteigerFactors[k][this.STEP_SIZE * j5 + j5 + 1] + ", a:" + gasteigerFactors[k][this.STEP_SIZE * j5 + j5]);
                    ++count;
                }
                logger.debug("Atom1:" + atom1 + ",Atom2:" + atom2);
                double max1 = Math.max(electronegativity[0], electronegativity[1]);
                double min1 = Math.min(electronegativity[0], electronegativity[1]);
                double DX = 1.0;
                DX = electronegativity[0] < electronegativity[1] ? gasteigerFactors[k][this.STEP_SIZE * atom1 + atom1 + 3] : gasteigerFactors[k][this.STEP_SIZE * atom2 + atom2 + 3];
                double Dq = (max1 - min1) / DX;
                logger.debug("Dq : " + Dq + " = (" + max1 + "-" + min1 + ")/" + DX);
                double epN1 = this.getElectrostaticPotentialN(iac2, atom1, gasteigerFactors[k]);
                double epN2 = this.getElectrostaticPotentialN(iac2, atom2, gasteigerFactors[k]);
                double SumQN = Math.abs(epN1 - epN2);
                logger.debug("sum(" + SumQN + ") = (" + epN1 + ") - (" + epN2 + ")");
                double WE = Dq + this.fE * SumQN;
                logger.debug("WE : " + WE + " = Dq(" + Dq + ")+fE(" + this.fE + ")*SumQN(" + SumQN);
                int iTE = iter + 1;
                double W = WE * Wt[k - 1] * this.fS / (double)iTE;
                logger.debug("W : " + W + " = WE(" + WE + ")*Wt(" + Wt[k - 1] + ")*fS(" + this.fS + ")/iter(" + iTE + "), atoms: " + atom1 + ", " + atom2);
                gasteigerFactors[k][this.STEP_SIZE * atom1 + atom1 + 5] = iac2.getAtom(atom1).getFormalCharge() == 0 ? (ac.getAtom(atom1).getFormalCharge() < 0 ? -1.0 * W : W) : (iac2.getAtom(atom1).getFormalCharge() > 0 ? W : -1.0 * W);
                if (iac2.getAtom(atom2).getFormalCharge() == 0) {
                    if (ac.getAtom(atom2).getFormalCharge() < 0) {
                        gasteigerFactors[k][this.STEP_SIZE * atom2 + atom2 + 5] = -1.0 * W;
                        continue;
                    }
                    gasteigerFactors[k][this.STEP_SIZE * atom2 + atom2 + 5] = W;
                    continue;
                }
                gasteigerFactors[k][this.STEP_SIZE * atom2 + atom2 + 5] = iac2.getAtom(atom2).getFormalCharge() > 0 ? W : -1.0 * W;
            }
            for (k = 1; k < iSet.getAtomContainerCount(); ++k) {
                for (int i5 = 0; i5 < ac.getAtomCount(); ++i5) {
                    if (!iSet.getAtomContainer(k).getAtom(i5).getFlag(ISCHANGEDFC)) continue;
                    double charge = ac.getAtom(i5).getCharge();
                    double chargeT = 0.0;
                    chargeT = charge + gasteigerFactors[k][this.STEP_SIZE * i5 + i5 + 5];
                    logger.debug("i<|" + ac.getAtom(i5).getSymbol() + ", " + chargeT + "=c:" + charge + "+g: " + gasteigerFactors[k][this.STEP_SIZE * i5 + i5 + 5]);
                    ac.getAtom(i5).setCharge(chargeT);
                }
            }
        }
        logger.debug("final");
        for (i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setFlag(32, oldAtomAromaticity[i]);
        }
        for (i = 0; i < ac.getBondCount(); ++i) {
            ac.getBond(i).setFlag(32, oldBondAromaticity[i]);
        }
        return ac;
    }

    @Override
    public void calculateCharges(IAtomContainer container) throws CDKException {
        try {
            this.assignGasteigerPiPartialCharges(container, true);
        }
        catch (Exception exception) {
            throw new CDKException("Could not calculate Gasteiger-Marsili PEPE charges: " + exception.getMessage(), exception);
        }
    }

    private IAtomContainer removingFlagsAromaticity(IAtomContainer ac) {
        Iterator<IAtom> atoms = ac.atoms().iterator();
        while (atoms.hasNext()) {
            atoms.next().setFlag(32, false);
        }
        Iterator<IBond> bonds = ac.bonds().iterator();
        while (bonds.hasNext()) {
            bonds.next().setFlag(32, false);
        }
        return ac;
    }

    private IAtomContainer setFlags(IAtomContainer container, IAtomContainer ac, boolean b) {
        Iterator<IChemObject> it = container.atoms().iterator();
        while (it.hasNext()) {
            int positionA = ac.indexOf(it.next());
            ac.getAtom(positionA).setFlag(1024, b);
        }
        it = container.bonds().iterator();
        while (it.hasNext()) {
            int positionB = ac.indexOf((IBond)it.next());
            ac.getBond(positionB).setFlag(1024, b);
        }
        return ac;
    }

    private IAtomContainer setAntiFlags(IAtomContainer container, IAtomContainer ac, int number, boolean b) {
        IBond bond = ac.getBond(number);
        if (container.contains(bond)) {
            return null;
        }
        bond.setFlag(1024, b);
        bond.getBegin().setFlag(1024, b);
        bond.getEnd().setFlag(1024, b);
        return ac;
    }

    private IAtomContainerSet getHyperconjugationInteractions(IAtomContainer ac, IAtomContainerSet iSet) throws IOException, ClassNotFoundException, CDKException {
        IAtomContainerSet set = ac.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        ReactionEngine type = new HeterolyticCleavageSBReaction();
        this.cleanFlagReactiveCenter(ac);
        boolean found = false;
        IAtomContainerSet setOfReactants = ac.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        block0: for (int i = 0; i < ac.getBondCount(); ++i) {
            if (ac.getBond(i).getOrder() == IBond.Order.SINGLE) continue;
            for (int j = 0; j < iSet.getAtomContainerCount(); ++j) {
                IAtomContainer ati = iSet.getAtomContainer(j);
                if (ati.equals(ac)) continue;
                for (int k = 0; k < ati.getBondCount(); ++k) {
                    IAtom a0 = ati.getBond(k).getBegin();
                    IAtom a1 = ati.getBond(k).getEnd();
                    if ((!a0.getSymbol().equals("H") || !a1.getSymbol().equals("H")) && (a0.getID().equals(ac.getBond(i).getBegin().getID()) && a1.getID().equals(ac.getBond(i).getEnd().getID()) || a1.getID().equals(ac.getBond(i).getBegin().getID()) && a0.getID().equals(ac.getBond(i).getEnd().getID())) && (a0.getFormalCharge() != 0 || a1.getFormalCharge() != 0)) continue block0;
                }
            }
            ac.getBond(i).getBegin().setFlag(1024, true);
            ac.getBond(i).getEnd().setFlag(1024, true);
            ac.getBond(i).setFlag(1024, true);
            found = true;
        }
        if (!found) {
            return null;
        }
        setOfReactants.addAtomContainer(ac);
        ArrayList<IParameterReact> paramList = new ArrayList<IParameterReact>();
        SetReactionCenter param = new SetReactionCenter();
        param.setParameter(Boolean.TRUE);
        paramList.add(param);
        type.setParameterList(paramList);
        IReactionSet setOfReactions = type.initiate(setOfReactants, null);
        for (int i = 0; i < setOfReactions.getReactionCount(); ++i) {
            type = new HyperconjugationReaction();
            IAtomContainerSet setOfM2 = ac.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            IAtomContainer mol = setOfReactions.getReaction(i).getProducts().getAtomContainer(0);
            for (int k = 0; k < mol.getBondCount(); ++k) {
                mol.getBond(k).setFlag(1024, false);
                mol.getBond(k).getBegin().setFlag(1024, false);
                mol.getBond(k).getEnd().setFlag(1024, false);
            }
            setOfM2.addAtomContainer(mol);
            ArrayList<IParameterReact> paramList2 = new ArrayList<IParameterReact>();
            SetReactionCenter param2 = new SetReactionCenter();
            param2.setParameter(Boolean.FALSE);
            paramList2.add(param);
            type.setParameterList(paramList2);
            IReactionSet setOfReactions2 = type.initiate(setOfM2, null);
            if (setOfReactions2.getReactionCount() <= 0) continue;
            IAtomContainer react = setOfReactions2.getReaction(0).getReactants().getAtomContainer(0);
            set.addAtomContainer(react);
        }
        return set;
    }

    private double getElectrostaticPotentialN(IAtomContainer ac, int atom1, double[] ds) {
        double CoulombForceConstant = 0.048;
        double sum = 0.0;
        try {
            if (this.factory == null) {
                this.factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/jmol_atomtypes.txt", ac.getBuilder());
            }
            List<IAtom> atoms = ac.getConnectedAtomsList(ac.getAtom(atom1));
            for (IAtom atom : atoms) {
                double covalentradius = 0.0;
                String symbol = atom.getSymbol();
                IAtomType type = this.factory.getAtomType(symbol);
                covalentradius = type.getCovalentRadius();
                double charge = ds[this.STEP_SIZE * atom1 + atom1 + 5];
                logger.debug("sum_(" + sum + ") = CFC(" + CoulombForceConstant + ")*charge(" + charge + "/ret(" + covalentradius);
                sum += CoulombForceConstant * charge / (covalentradius * covalentradius);
            }
        }
        catch (CDKException e) {
            logger.debug(e);
        }
        return sum;
    }

    private double getTopologicalFactors(IAtomContainer atomContainer, IAtomContainer ac) {
        int totalNCharge1 = AtomContainerManipulator.getTotalNegativeFormalCharge(atomContainer);
        int totalPCharge1 = AtomContainerManipulator.getTotalPositiveFormalCharge(atomContainer);
        double fQ = 1.0;
        if ((double)totalNCharge1 != 0.0) {
            fQ = 0.5;
            for (int i = 0; i < atomContainer.getBondCount(); ++i) {
                IBond bond = atomContainer.getBond(i);
                if ((double)bond.getBegin().getFormalCharge().intValue() == 0.0 || (double)bond.getEnd().getFormalCharge().intValue() == 0.0) continue;
                fQ = 0.25;
                break;
            }
        }
        double fB = 1.0;
        int numBond1 = 0;
        int numBond2 = 0;
        for (int i = 0; i < atomContainer.getBondCount(); ++i) {
            if (atomContainer.getBond(i).getOrder() == IBond.Order.DOUBLE) {
                ++numBond1;
            }
            if (ac.getBond(i).getOrder() != IBond.Order.DOUBLE) continue;
            ++numBond2;
        }
        if (numBond1 < numBond2) {
            fB = 0.8;
        }
        double fPlus = 1.0;
        if ((double)totalNCharge1 == 0.0 && (double)totalPCharge1 == 0.0) {
            fPlus = 0.1;
        }
        double fA = 1.0;
        try {
            if (Aromaticity.cdkLegacy().apply(ac) && !Aromaticity.cdkLegacy().apply(atomContainer)) {
                fA = 0.3;
            }
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        logger.debug("return " + fQ * fB * fPlus * fA + "= sp:" + fQ + ", dc:" + fB + ", fPlus:" + fPlus + ", fA:" + fA);
        return fQ * fB * fPlus * fA;
    }

    public int getStepSize() {
        return this.STEP_SIZE;
    }

    public void setStepSize(int step) {
        this.STEP_SIZE = step;
    }

    private double[][] assignPiFactors(IAtomContainerSet setAc) {
        double[][] gasteigerFactors = new double[setAc.getAtomContainerCount()][setAc.getAtomContainer(0).getAtomCount() * (this.STEP_SIZE + 1)];
        String AtomSymbol2 = "";
        double[] factors = new double[]{0.0, 0.0, 0.0};
        for (int k = 1; k < setAc.getAtomContainerCount(); ++k) {
            IAtomContainer ac = setAc.getAtomContainer(k);
            for (int i = 0; i < ac.getAtomCount(); ++i) {
                factors[0] = 0.0;
                factors[1] = 0.0;
                factors[2] = 0.0;
                AtomSymbol2 = ac.getAtom(i).getSymbol();
                if (AtomSymbol2.equals("H")) {
                    factors[0] = 0.0;
                    factors[1] = 0.0;
                    factors[2] = 0.0;
                } else if (AtomSymbol2.equals("C")) {
                    factors[0] = 5.6;
                    factors[1] = 8.93;
                    factors[2] = 2.94;
                } else if (AtomSymbol2.equals("O")) {
                    if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE) {
                        factors[0] = 10.0;
                        factors[1] = 13.86;
                        factors[2] = 9.68;
                    } else {
                        factors[0] = 7.91;
                        factors[1] = 14.76;
                        factors[2] = 6.85;
                    }
                } else if (AtomSymbol2.equals("N")) {
                    if (ac.getMaximumBondOrder(ac.getAtom(i)) != IBond.Order.SINGLE) {
                        factors[0] = 7.95;
                        factors[1] = 9.73;
                        factors[2] = 2.67;
                    } else {
                        factors[0] = 4.54;
                        factors[1] = 11.86;
                        factors[2] = 7.32;
                    }
                } else if (AtomSymbol2.equals("S")) {
                    if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE) {
                        factors[0] = 7.73;
                        factors[1] = 8.16;
                        factors[2] = 1.81;
                    } else {
                        factors[0] = 6.6;
                        factors[1] = 10.32;
                        factors[2] = 3.72;
                    }
                } else if (AtomSymbol2.equals("F")) {
                    factors[0] = 7.34;
                    factors[1] = 13.86;
                    factors[2] = 9.68;
                } else if (AtomSymbol2.equals("Cl")) {
                    factors[0] = 6.5;
                    factors[1] = 11.02;
                    factors[2] = 4.52;
                } else if (AtomSymbol2.equals("Br")) {
                    factors[0] = 5.2;
                    factors[1] = 9.68;
                    factors[2] = 4.48;
                } else if (AtomSymbol2.equals("I")) {
                    factors[0] = 4.95;
                    factors[1] = 8.81;
                    factors[2] = 3.86;
                }
                gasteigerFactors[k][this.STEP_SIZE * i + i] = factors[0];
                gasteigerFactors[k][this.STEP_SIZE * i + i + 1] = factors[1];
                gasteigerFactors[k][this.STEP_SIZE * i + i + 2] = factors[2];
                gasteigerFactors[k][this.STEP_SIZE * i + i + 5] = ac.getAtom(i).getCharge();
                gasteigerFactors[k][this.STEP_SIZE * i + i + 3] = factors[0] == 0.0 && factors[1] == 0.0 && factors[2] == 0.0 ? 1.0 : factors[0] + factors[1] + factors[2];
            }
        }
        return gasteigerFactors;
    }

    public double[][] assignrPiMarsilliFactors(IAtomContainerSet setAc) {
        double[][] gasteigerFactors = new double[setAc.getAtomContainerCount()][setAc.getAtomContainer(0).getAtomCount() * (this.STEP_SIZE + 1)];
        String AtomSymbol2 = "";
        double[] factors = new double[]{0.0, 0.0, 0.0};
        for (int k = 1; k < setAc.getAtomContainerCount(); ++k) {
            IAtomContainer ac = setAc.getAtomContainer(k);
            for (int i = 0; i < ac.getAtomCount(); ++i) {
                factors[0] = 0.0;
                factors[1] = 0.0;
                factors[2] = 0.0;
                AtomSymbol2 = ac.getAtom(i).getSymbol();
                if (AtomSymbol2.equals("H")) {
                    factors[0] = 0.0;
                    factors[1] = 0.0;
                    factors[2] = 0.0;
                } else if (AtomSymbol2.equals("C")) {
                    factors[0] = 5.98;
                    factors[1] = 7.93;
                    factors[2] = 1.94;
                } else if (AtomSymbol2.equals("O")) {
                    if (ac.getMaximumBondOrder(ac.getAtom(i)) != IBond.Order.SINGLE) {
                        factors[0] = 11.2;
                        factors[1] = 13.24;
                        factors[2] = 9.68;
                    } else {
                        factors[0] = 7.91;
                        factors[1] = 14.76;
                        factors[2] = 6.85;
                    }
                } else if (AtomSymbol2.equals("N")) {
                    if (ac.getMaximumBondOrder(ac.getAtom(i)) != IBond.Order.SINGLE) {
                        factors[0] = 8.95;
                        factors[1] = 9.73;
                        factors[2] = 2.67;
                    } else {
                        factors[0] = 4.54;
                        factors[1] = 11.86;
                        factors[2] = 7.32;
                    }
                } else if (AtomSymbol2.equals("P")) {
                    if (ac.getMaximumBondOrder(ac.getAtom(i)) != IBond.Order.SINGLE) {
                        factors[0] = 10.73;
                        factors[1] = 11.16;
                        factors[2] = 6.81;
                    } else {
                        factors[0] = 9.6;
                        factors[1] = 13.32;
                        factors[2] = 2.72;
                    }
                } else if (AtomSymbol2.equals("S")) {
                    if (ac.getMaximumBondOrder(ac.getAtom(i)) != IBond.Order.SINGLE) {
                        factors[0] = 7.73;
                        factors[1] = 8.16;
                        factors[2] = 1.81;
                    } else {
                        factors[0] = 6.6;
                        factors[1] = 10.32;
                        factors[2] = 3.72;
                    }
                } else if (AtomSymbol2.equals("F")) {
                    factors[0] = 7.14;
                    factors[1] = 13.86;
                    factors[2] = 5.68;
                } else if (AtomSymbol2.equals("Cl")) {
                    factors[0] = 6.51;
                    factors[1] = 11.02;
                    factors[2] = 4.52;
                } else if (AtomSymbol2.equals("Br")) {
                    factors[0] = 5.2;
                    factors[1] = 9.68;
                    factors[2] = 4.48;
                } else if (AtomSymbol2.equals("I")) {
                    factors[0] = 4.95;
                    factors[1] = 8.81;
                    factors[2] = 3.86;
                }
                gasteigerFactors[k][this.STEP_SIZE * i + i] = factors[0];
                gasteigerFactors[k][this.STEP_SIZE * i + i + 1] = factors[1];
                gasteigerFactors[k][this.STEP_SIZE * i + i + 2] = factors[2];
                gasteigerFactors[k][this.STEP_SIZE * i + i + 5] = ac.getAtom(i).getCharge();
                gasteigerFactors[k][this.STEP_SIZE * i + i + 3] = factors[0] == 0.0 && factors[1] == 0.0 && factors[2] == 0.0 ? 1.0 : factors[0] + factors[1] + factors[2];
            }
        }
        return gasteigerFactors;
    }

    private void cleanFlagReactiveCenter(IAtomContainer ac) {
        int j;
        for (j = 0; j < ac.getAtomCount(); ++j) {
            ac.getAtom(j).setFlag(1024, false);
        }
        for (j = 0; j < ac.getBondCount(); ++j) {
            ac.getBond(j).setFlag(1024, false);
        }
    }
}

