/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import java.util.List;
import org.openscience.cdk.io.formats.AbstractResourceFormat;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

public class MDLRXNV3000Format
extends AbstractResourceFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new MDLRXNV3000Format();
        }
        return myself;
    }

    @Override
    public String getFormatName() {
        return "MDL RXN V3000";
    }

    @Override
    public String getMIMEType() {
        return "chemical/x-mdl-rxnfile";
    }

    @Override
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    public String[] getNameExtensions() {
        return new String[]{"rxn"};
    }

    @Override
    public String getReaderClassName() {
        return "org.openscience.cdk.io.MDLRXNV3000Reader";
    }

    @Override
    public String getWriterClassName() {
        return null;
    }

    @Override
    public IChemFormatMatcher.MatchResult matches(List<String> lines) {
        String header;
        if (lines.size() < 1 || !lines.get(0).contains("$RXN")) {
            return NO_MATCH;
        }
        String string = header = lines.size() > 4 ? lines.get(4) : "";
        if (header.length() < 3 || !Character.isDigit(header.charAt(2))) {
            return NO_MATCH;
        }
        if (header.length() < 6 || !Character.isDigit(header.charAt(5))) {
            return NO_MATCH;
        }
        if (header.length() > 6) {
            String remainder = header.substring(6).trim();
            for (int i = 0; i < remainder.length(); ++i) {
                char c = remainder.charAt(i);
                if (Character.isDigit(c) || Character.isWhitespace(c)) continue;
                return NO_MATCH;
            }
        }
        return new IChemFormatMatcher.MatchResult(true, this, 0);
    }

    @Override
    public boolean isXMLBased() {
        return false;
    }

    @Override
    public int getSupportedDataFeatures() {
        return 0;
    }

    @Override
    public int getRequiredDataFeatures() {
        return 0;
    }
}

