/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class IteratingSDFReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingSDFReader.class);
    private String currentLine;
    private IChemFormat currentFormat;
    private final ReaderFactory factory = new ReaderFactory();
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IChemObjectBuilder builder;
    private IAtomContainer nextMolecule;
    private BooleanIOSetting forceReadAs3DCoords;
    private boolean skip = false;
    private StringBuilder buffer = new StringBuilder(10000);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Pattern MDL_VERSION = Pattern.compile("[vV](2000|3000)");
    private static String M_END = "M  END";
    private static String SDF_RECORD_SEPARATOR = "$$$$";
    private static String SDF_DATA_HEADER = "> ";
    private final Map<IChemFormat, ISimpleChemObjectReader> readerMap = new HashMap<IChemFormat, ISimpleChemObjectReader>(5);

    public IteratingSDFReader(Reader in, IChemObjectBuilder builder) {
        this(in, builder, false);
    }

    public IteratingSDFReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    public IteratingSDFReader(InputStream in, IChemObjectBuilder builder, boolean skip) {
        this(new InputStreamReader(in), builder, skip);
    }

    public IteratingSDFReader(Reader in, IChemObjectBuilder builder, boolean skip) {
        this.builder = builder;
        this.setReader(in);
        this.initIOSettings();
        this.setSkip(skip);
    }

    @Override
    public IResourceFormat getFormat() {
        return this.currentFormat;
    }

    private ISimpleChemObjectReader getReader(IChemFormat format) {
        if (!this.readerMap.containsKey(format)) {
            ISimpleChemObjectReader reader = this.factory.createReader(format);
            reader.setErrorHandler(this.errorHandler);
            reader.setReaderMode(this.mode);
            if (this.currentFormat instanceof MDLV2000Format) {
                reader.addSettings(this.getSettings());
            }
            this.readerMap.put(format, reader);
        }
        return this.readerMap.get(format);
    }

    @Override
    public boolean hasNext() {
        if (this.nextAvailableIsKnown) {
            return this.hasNext;
        }
        this.hasNext = false;
        this.nextMolecule = null;
        try {
            this.currentFormat = (IChemFormat)MDLFormat.getInstance();
            int lineNum = 0;
            this.buffer.setLength(0);
            while ((this.currentLine = this.input.readLine()) != null) {
                Matcher versionMatcher;
                this.buffer.append(this.currentLine).append(LINE_SEPARATOR);
                if (++lineNum == 4 && (versionMatcher = MDL_VERSION.matcher(this.currentLine)).find()) {
                    IChemFormat iChemFormat = this.currentFormat = "2000".equals(versionMatcher.group(1)) ? (IChemFormat)MDLV2000Format.getInstance() : (IChemFormat)MDLV3000Format.getInstance();
                }
                if (this.currentLine.startsWith(M_END)) {
                    logger.debug("MDL file part read: ", this.buffer);
                    IAtomContainer molecule = null;
                    try {
                        ISimpleChemObjectReader reader = this.getReader(this.currentFormat);
                        reader.setReader(new StringReader(this.buffer.toString()));
                        molecule = reader.read(this.builder.newAtomContainer());
                    }
                    catch (Exception exception) {
                        logger.error("Error while reading next molecule: " + exception.getMessage());
                        logger.debug(exception);
                    }
                    if (molecule != null) {
                        this.readDataBlockInto(molecule);
                        this.hasNext = true;
                        this.nextAvailableIsKnown = true;
                        this.nextMolecule = molecule;
                        return true;
                    }
                    if (this.skip) {
                        String line;
                        while ((line = this.input.readLine()) != null && !line.startsWith(SDF_RECORD_SEPARATOR)) {
                        }
                    } else {
                        return false;
                    }
                    this.buffer.setLength(0);
                    lineNum = 0;
                }
                if (!this.currentLine.startsWith(SDF_RECORD_SEPARATOR)) continue;
                this.buffer.setLength(0);
                lineNum = 0;
            }
        }
        catch (IOException exception) {
            logger.error("Error while reading next molecule: " + exception.getMessage());
            logger.debug(exception);
        }
        return false;
    }

    private void readDataBlockInto(IAtomContainer m) throws IOException {
        String dataHeader = null;
        StringBuilder sb = new StringBuilder();
        this.currentLine = this.input.readLine();
        while (this.currentLine != null && !this.currentLine.startsWith(SDF_RECORD_SEPARATOR)) {
            logger.debug("looking for data header: ", this.currentLine);
            String str = this.currentLine;
            if (!str.startsWith(SDF_DATA_HEADER)) break;
            dataHeader = this.extractFieldName(str);
            this.skipOtherFieldHeaderLines(str);
            String data = this.extractFieldData(sb);
            if (dataHeader == null) continue;
            logger.info("fieldName, data: ", dataHeader, ", ", data);
            m.setProperty(dataHeader, data);
        }
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private String extractFieldData(StringBuilder data) throws IOException {
        data.setLength(0);
        while (this.currentLine != null && !this.currentLine.startsWith(SDF_RECORD_SEPARATOR) && !this.currentLine.startsWith(SDF_DATA_HEADER)) {
            logger.debug("data line: ", this.currentLine);
            if (data.length() > 0) {
                data.append('\n');
            }
            data.append(this.currentLine);
            this.currentLine = this.input.readLine();
        }
        int len = data.length();
        if (len > 1 && data.charAt(len - 1) == '\n') {
            data.setLength(len - 1);
        }
        return data.toString();
    }

    private String skipOtherFieldHeaderLines(String str) throws IOException {
        while (str.startsWith(SDF_DATA_HEADER)) {
            logger.debug("data header line: ", this.currentLine);
            str = this.currentLine = this.input.readLine();
        }
        return str;
    }

    private String extractFieldName(String str) {
        int index2;
        int index = str.indexOf(60);
        if (index != -1 && (index2 = str.indexOf(62, index)) != -1) {
            return str.substring(index + 1, index2);
        }
        return null;
    }

    @Override
    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false");
        this.addSetting(this.forceReadAs3DCoords);
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.forceReadAs3DCoords);
    }
}

