/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import org.openscience.cdk.charges.Electronegativity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IBondDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class BondSigmaElectronegativityDescriptor
extends AbstractBondDescriptor
implements IBondDescriptor {
    private int maxIterations = 6;
    private Electronegativity electronegativity = new Electronegativity();
    private static final String[] NAMES = new String[]{"elecSigB"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondSigmaElectronegativity", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("SigmaElectronegativityDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        if (params.length == 0) {
            return;
        }
        this.maxIterations = (Integer)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, e);
    }

    @Override
    public DescriptorValue calculate(IBond aBond, IAtomContainer atomContainer) {
        IBond bond;
        IAtomContainer ac;
        try {
            ac = atomContainer.clone();
            bond = ac.getBond(atomContainer.indexOf(aBond));
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(e);
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        if (this.maxIterations != -1 && this.maxIterations != 0) {
            this.electronegativity.setMaxIterations(this.maxIterations);
        }
        double electroAtom1 = this.electronegativity.calculateSigmaElectronegativity(ac, bond.getBegin());
        double electroAtom2 = this.electronegativity.calculateSigmaElectronegativity(ac, bond.getEnd());
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Math.abs(electroAtom1 - electroAtom2)), NAMES);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return 0;
    }
}

