/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.maygen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.group.Permutation;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.structgen.maygen.Maygen;

class Generation {
    private final Maygen maygen;

    public Generation(Maygen maygen) {
        this.maygen = maygen;
    }

    public void run(int[] degree) {
        int[] initialPartition;
        IAtomContainer atomContainer = this.maygen.getBuilder().newAtomContainer();
        int[] partSize = new int[]{0};
        int[] r = new int[]{0};
        int[] y = new int[]{0};
        int[] z = new int[]{0};
        int[][] ys = new int[][]{new int[0]};
        int[][] zs = new int[][]{new int[0]};
        boolean[] learningFromCanonicalTest = new boolean[]{false};
        boolean[] learningFromConnectivity = new boolean[]{false};
        int[] nonCanonicalIndices = new int[2];
        ArrayList<ArrayList<Permutation>> formerPermutations = new ArrayList<ArrayList<Permutation>>();
        int[] hydrogens = this.maygen.setHydrogens(degree);
        int[] newPartition = this.maygen.getPartition(degree);
        String[] symbolArrayCopy = this.maygen.getSymbolArray();
        if (this.maygen.getConsumer() != Maygen.NOOP_CONSUMER) {
            symbolArrayCopy = Arrays.copyOf(this.maygen.getSymbolArray(), this.maygen.getSymbolArray().length);
            initialPartition = this.maygen.sortWithPartition(newPartition, degree, symbolArrayCopy, hydrogens);
            atomContainer = this.maygen.initAC(atomContainer, symbolArrayCopy);
        } else {
            initialPartition = this.maygen.sortWithPartition(newPartition, degree, this.maygen.getSymbolArray(), hydrogens);
        }
        int[] connectivityIndices = new int[2];
        int[][] partitionList = new int[this.maygen.getSize() + 1][1];
        try {
            partSize[0] = partSize[0] + (this.maygen.findZeros(initialPartition) - 1);
            this.maygen.setYZValues(initialPartition, ys, zs);
            partitionList[0] = initialPartition;
            this.maygen.generate(atomContainer, symbolArrayCopy, degree, initialPartition, partitionList, connectivityIndices, learningFromConnectivity, nonCanonicalIndices, formerPermutations, hydrogens, partSize, r, y, z, ys, zs, learningFromCanonicalTest);
        }
        catch (IOException | CloneNotSupportedException | CDKException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }
}

