% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-inttime.R, R/op-cdo-intntime.R,
%   R/op-cdo-inttime.R
\name{inttime}
\alias{inttime}
\alias{cdo_intntime}
\alias{cdo_inttime}
\title{Time interpolation}
\usage{
cdo_intntime(
  ifile,
  date = NULL,
  time = NULL,
  inc = NULL,
  n = NULL,
  ofile = NULL
)

cdo_inttime(
  ifile,
  date = NULL,
  time = NULL,
  inc = NULL,
  n = NULL,
  ofile = NULL
)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{date}{STRING - Start date (format YYYY-MM-DD)}

\item{time}{STRING - Start time (format hh:mm:ss)}

\item{inc}{STRING - Optional increment (seconds, minutes, hours, days, months, years) [default: 0hour]}

\item{n}{INTEGER - Number of timesteps from one timestep to the next}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module performs linear interpolation between timesteps. Interpolation is only performed if both values exist. If both values are missing values, the result is also a missing value. If only one value exists, it is taken if the time weighting is greater than or equal to 0.5. So no new value will be created at existing time steps, if the value is missing there.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{inttime   Interpolation between timesteps
          This operator creates a new dataset by linear interpolation between timesteps.
          The user has to define the start date/time with an optional increment.
intntime  Interpolation between timesteps
          This operator performs linear interpolation between timesteps.
          The user has to define the number of timesteps from one timestep to the next.
}\if{html}{\out{</div>}}
}
