% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_articles_history.R
\name{core_articles_history}
\alias{core_articles_history}
\alias{core_articles_history_}
\title{Get article history}
\usage{
core_articles_history(id, page = 1, limit = 10, key = NULL,
  parse = TRUE, ...)

core_articles_history_(id, page = 1, limit = 10, key = NULL, ...)
}
\arguments{
\item{id}{(integer) CORE ID of the article that needs to be fetched.
Required}

\item{page}{(character) page number (default: 1), optional}

\item{limit}{(character) records to return (default: 10, minimum: 10),
optional}

\item{key}{A IUCN API token}

\item{parse}{(logical) Whether to parse to list (`FALSE`) or
data.frame (`TRUE`). Default: `TRUE`}

\item{...}{Curl options passed to [crul::HttpClient()]}
}
\description{
Get article history
}
\details{
\code{core_articles_history} does the HTTP request and parses,
while \code{core_articles_history_} just does the HTTP request, gives back JSON
as a character string

These functions take one article ID at a time. Use lapply/loops/etc for
many ids
}
\examples{
\dontrun{
core_articles_history(id = '21132995')

ids <- c(20955435, 21132995, 21813171, 22815670, 14045109, 23828884,
   23465055, 23831838, 23923390, 22559733)
res <- lapply(ids, core_articles_history)
vapply(res, function(z) z$data$datetime[1], "")

# just http request, get text back
core_articles_history_('21132995')
}
}
\references{
\url{https://core.ac.uk/docs/#!/articles/getArticleHistoryByCoreId}
}
