% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corridor.R
\name{corridor_edge}
\alias{corridor_edge}
\title{Draw a corridor edge on the spatial network.}
\usage{
corridor_edge(
  network,
  end_points,
  target_edge,
  exclude_area = NULL,
  max_iterations = 10
)
}
\arguments{
\item{network}{The spatial network used for the delineation}

\item{end_points}{Target start- and end-point}

\item{target_edge}{Target edge geometry to follow in the delineation}

\item{exclude_area}{Region that we aim to exclude from the delineation}

\item{max_iterations}{Maximum number of iterations employed to refine the
corridor edges}
}
\value{
An \code{\link[sf:sfc]{sf::sfc_LINESTRING}} object representing the edge
}
\description{
The corridor edge is drawn on the network as a shortest-path link between a
start- and an end-point. The weights in the shortest-path problem are set to
account for a) network edge lengths, b) distance from an initial target edge
geometry, and c) an excluded area where corridor edges are aimed not to go
through. The procedure is iterative, with the excluded area only being
accounted for in the first iteration. The identified corridor edge is
used as target edge in the following iteration, with the goal of prioritising
the "straightening" of the edge (some overlap with the excluded area is
allowed).
}
\keyword{internal}
