% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_desc.R
\name{crt_iteman}
\alias{crt_iteman}
\title{Calculate criterion-referenced item discrimination indices}
\usage{
crt_iteman(data, items, cut_score, scale = "raw")
}
\arguments{
\item{data}{A data frame of dichotomously scored test times}

\item{items}{Raw column indices representing the test items}

\item{cut_score}{A raw or percentage cut-score}

\item{scale}{A character vector indicating whether the cut-score
is 'raw' (default) or 'percent'}
}
\value{
\code{if_pass} contains item facility values for test items for students who 
passed the test

\code{if_fail} contains item facility values for test items for students who did not pass the test

\code{if_total} contains item facility values for test items

\code{b_index} contains b-index values for items on the test

\code{agree_stat} contains agreement statistic values for items on the test

\code{item_phi} contains item phi values for items on the test
}
\description{
Calculate criterion-referenced item discrimination indices
}
\examples{
crt_iteman(bh_depend, 2:31, 21, scale = 'raw')
}
