% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mfrd.R
\name{summary.mfrd}
\alias{summary.mfrd}
\title{Summarize the Multivariate Frontier Regression Discontinuity}
\usage{
\method{summary}{mfrd}(object, level = 0.95, digits = max(3,
  getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class \code{"mfrd"}, usually a result of a call to \code{\link{mfrd_est}}.}

\item{level}{Numerical value between 0 and 1. Confidence level for confidence intervals.}

\item{digits}{Number of digits to display.}

\item{...}{Additional arguments.}
}
\value{
\code{summary.mfrd} returns a list which has the following components:
\item{coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the complete model.}
\item{ht_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the heterogeneous treatment model.}
\item{t_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the treatment only model.}
}
\description{
\code{summary.mfrd} is a \code{summary} method for class \code{"mfrd"}
It is based on \code{\link[rdd]{summary.RD}} function in the \pkg{rdd} package.
}
