% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{ddi_codingInstructions}
\alias{ddi_codingInstructions}
\alias{ddi_command}
\title{codingInstructions and its child nodes}
\usage{
ddi_codingInstructions(...)

ddi_command(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Describe specific coding instructions used in data processing, cleaning,
assession, or tabulation. Element relatedProcesses allows linking a coding
instruction to one or more processes such as dataProcessing, dataAppr,
cleanOps, etc. Use the txt element to describe instructions in a human
readable form. More information on these elements, especially their allowed
attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{codingInstructions} is contained in \code{method}.

\emph{codingInstructions specific child nodes}
\itemize{
\item \code{ddi_command()} provides command code for the coding instruction. The
formalLanguage attribute identifies the language of the command code.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_txt]{ddi_txt()}}
}
}

\examples{
ddi_codingInstructions()

# Functions that need to be wrapped in ddi_codingInstructions()

ddi_command(formalLanguage = "SPSS",
            "RECODE V1 TO V100 (10 THROUGH HIGH = 0)")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codingInstructions.html}{codingInstructions documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/command.html}{command documentation}
}
