% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_nCubeGrp}
\alias{ddi_nCubeGrp}
\title{nCubeGrp and its child nodes}
\usage{
ddi_nCubeGrp(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
A group of nCubes that may share a common subject, arise from the
interpretation of a single question, or are linked by some other factor.
This element makes it possible to identify all nCubes derived from a simple
presentation table, and to provide the original table title and universe,
as well as reference the source. Specific nesting patterns can be described
using the attribute nCubeGrp. nCube groups are also created this way in
order to permit nCubes to belong to multiple groups, including multiple
subject groups, without causing overlapping groups. nCubes that are linked
by the same use of the same variable need not be identified by an nCubeGrp
element because they are already linked by a common variable element. Note
that as a result of the strict sequencing required by XML, all nCube Groups
must be marked up before the Variable element is opened. That is, the
mark-up author cannot mark up a nCube Group, then mark up its constituent
nCubes, then mark up another nCube Group. More information on these elements,
especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{nCubeGrp} is contained in \code{dataDscr}.
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_concept]{ddi_concept()}}
\item \code{\link[=ddi_defntn]{ddi_defntn()}}
\item \code{\link[=ddi_labl]{ddi_labl()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
\item \code{\link[=ddi_txt]{ddi_txt()}}
\item \code{\link[=ddi_universe]{ddi_universe()}}
}
}

\examples{
ddi_nCubeGrp(name = "Group 1")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/nCubeGrp.html}{nCubeGrp documentation}
}
