% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rddtools.R
\docType{data}
\name{house}
\alias{house}
\title{Dataset used in Lee (2008)}
\format{
A data frame with 6558 observations and two variables:
\describe{
\item{x}{Vote at election t-1}
\item{y}{Vote at election t}
}
}
\source{
Guido Imbens webpage: \url{https://scholar.harvard.edu/imbens/scholar_software/regression-discontinuity}
}
\description{
Randomized experiments from non-random selection in U.S. House elections

Dataset described used in Imbens and Kalyamaran (2012), and probably the same dataset used in Lee (2008),
}
\examples{
data(house)
rdd_house <- rdd_data(x=x, y=y, data=house, cutpoint=0)
summary(rdd_house)
plot(rdd_house)
}
\references{
Imbens, Guido and Karthik Kalyanaraman. (2012) 'Optimal Bandwidth Choice for the regression discontinuity estimator,' 
Review of Economic Studies (2012) 79, 933-959

Lee, D. (2008) Randomized experiments from non-random selection in U.S. House elections, 
\emph{Journal of Econometrics}, 142, 675-697
}
