% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Digraph.R
\docType{class}
\name{Digraph}
\alias{Digraph}
\title{A directed graph}
\description{
An R6 class representing a digraph (a directed graph).
}
\details{
Encapsulates and provides methods for computation and checking of 
directed graphs (digraphs). Inherits from class \code{Graph}.
}
\references{
{ 
  Gansner ER, Koutsofios E, North SC, Vo K-P. A technique for drawing
  directed graphs. \emph{IEEE Transactions on Software Engineering},
  1993;\bold{19}:214–30, \doi{10.1109/32.221135}.

  Gross JL, Yellen J, Zhang P. Handbook of Graph Theory. Second edition, 
  Chapman and Hall/CRC.; 2013, \doi{10.1201/b16132}.

  Kahn AB, Topological Sorting of Large Networks, 
  \emph{Communications of the \acronym{ACM}},
  1962;\strong{5}:558-562, \doi{10.1145/368996.369025}.
}
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Graph]{rdecision::Graph}} -> \code{Digraph}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Digraph-new}{\code{Digraph$new()}}
\item \href{#method-Digraph-digraph_adjacency_matrix}{\code{Digraph$digraph_adjacency_matrix()}}
\item \href{#method-Digraph-digraph_incidence_matrix}{\code{Digraph$digraph_incidence_matrix()}}
\item \href{#method-Digraph-topological_sort}{\code{Digraph$topological_sort()}}
\item \href{#method-Digraph-is_connected}{\code{Digraph$is_connected()}}
\item \href{#method-Digraph-is_weakly_connected}{\code{Digraph$is_weakly_connected()}}
\item \href{#method-Digraph-is_acyclic}{\code{Digraph$is_acyclic()}}
\item \href{#method-Digraph-is_tree}{\code{Digraph$is_tree()}}
\item \href{#method-Digraph-is_polytree}{\code{Digraph$is_polytree()}}
\item \href{#method-Digraph-is_arborescence}{\code{Digraph$is_arborescence()}}
\item \href{#method-Digraph-direct_successors}{\code{Digraph$direct_successors()}}
\item \href{#method-Digraph-direct_predecessors}{\code{Digraph$direct_predecessors()}}
\item \href{#method-Digraph-paths}{\code{Digraph$paths()}}
\item \href{#method-Digraph-walk}{\code{Digraph$walk()}}
\item \href{#method-Digraph-as_DOT}{\code{Digraph$as_DOT()}}
\item \href{#method-Digraph-clone}{\code{Digraph$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="degree"><a href='../../rdecision/html/Graph.html#method-Graph-degree'><code>rdecision::Graph$degree()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="edge_along"><a href='../../rdecision/html/Graph.html#method-Graph-edge_along'><code>rdecision::Graph$edge_along()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="edge_at"><a href='../../rdecision/html/Graph.html#method-Graph-edge_at'><code>rdecision::Graph$edge_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="edge_index"><a href='../../rdecision/html/Graph.html#method-Graph-edge_index'><code>rdecision::Graph$edge_index()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="graph_adjacency_matrix"><a href='../../rdecision/html/Graph.html#method-Graph-graph_adjacency_matrix'><code>rdecision::Graph$graph_adjacency_matrix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_edge"><a href='../../rdecision/html/Graph.html#method-Graph-has_edge'><code>rdecision::Graph$has_edge()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_vertex"><a href='../../rdecision/html/Graph.html#method-Graph-has_vertex'><code>rdecision::Graph$has_vertex()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="is_simple"><a href='../../rdecision/html/Graph.html#method-Graph-is_simple'><code>rdecision::Graph$is_simple()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="neighbours"><a href='../../rdecision/html/Graph.html#method-Graph-neighbours'><code>rdecision::Graph$neighbours()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="order"><a href='../../rdecision/html/Graph.html#method-Graph-order'><code>rdecision::Graph$order()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="size"><a href='../../rdecision/html/Graph.html#method-Graph-size'><code>rdecision::Graph$size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="vertex_along"><a href='../../rdecision/html/Graph.html#method-Graph-vertex_along'><code>rdecision::Graph$vertex_along()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="vertex_at"><a href='../../rdecision/html/Graph.html#method-Graph-vertex_at'><code>rdecision::Graph$vertex_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="vertex_index"><a href='../../rdecision/html/Graph.html#method-Graph-vertex_index'><code>rdecision::Graph$vertex_index()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-new"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Digraph} object from sets of nodes and edges.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$new(V, A)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{V}}{A list of Nodes.}

\item{\code{A}}{A list of Arrows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Digraph object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-digraph_adjacency_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-digraph_adjacency_matrix}{}}}
\subsection{Method \code{digraph_adjacency_matrix()}}{
Compute the adjacency matrix for the digraph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$digraph_adjacency_matrix(boolean = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{boolean}}{If \code{TRUE}, the adjacency matrix is logical, each 
cell is \code{{FALSE,TRUE}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Each cell contains the number of edges from the row vertex to
the column vertex, with the convention of self loops being counted once,
unless \code{boolean} is \code{TRUE} when cells are either \code{FALSE}
(not adjacent) or \code{TRUE} (adjacent).
}

\subsection{Returns}{
A square numeric matrix with the number of rows and columns
equal to the order of the graph. The rows and columns are in the
same order as \code{V}. If the nodes have defined and unique labels the
dimnames of the matrix are the labels of the nodes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-digraph_incidence_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-digraph_incidence_matrix}{}}}
\subsection{Method \code{digraph_incidence_matrix()}}{
Compute the incidence matrix for the digraph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$digraph_incidence_matrix()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Each row is a vertex and each column is an edge. Edges leaving
a vertex have value -1 and edges entering have value +1. By convention
self loops have value 0 (1-1). If all vertexes have defined and unique 
labels and all edges have defined and unique labels, the dimnames of the
matrix are the labels of the vertexes and edges.
}

\subsection{Returns}{
The incidence matrix.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-topological_sort"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-topological_sort}{}}}
\subsection{Method \code{topological_sort()}}{
Topologically sort the vertexes in the digraph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$topological_sort()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Uses Kahn's algorithm (Kahn, 1962).
}

\subsection{Returns}{
A list of vertexes, topologically sorted. If the digraph has
cycles, the returned ordered list will not contain all the vertexes
in the graph, but no error will be raised.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-is_connected"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-is_connected}{}}}
\subsection{Method \code{is_connected()}}{
Test whether the graph is connected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_connected()}\if{html}{\out{</div>}}
}

\subsection{Details}{
For digraphs this will always return \code{FALSE} because
\dfn{connected} is not defined. Function \code{weakly_connected} 
calculates whether the underlying graph is connected.
}

\subsection{Returns}{
\code{TRUE} if connected, \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-is_weakly_connected"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-is_weakly_connected}{}}}
\subsection{Method \code{is_weakly_connected()}}{
Test whether the digraph is weakly connected, i.e. if the
underlying graph is connected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_weakly_connected()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if connected, \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-is_acyclic"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-is_acyclic}{}}}
\subsection{Method \code{is_acyclic()}}{
Checks for the presence of a cycle in the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_acyclic()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Attempts to do a topological sort. If the sort does not contain
all vertexes, the digraph contains at least one cycle. This method 
overrides \code{is_acyclic} in \code{Graph}.
}

\subsection{Returns}{
\code{TRUE} if no cycles detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-is_tree"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-is_tree}{}}}
\subsection{Method \code{is_tree()}}{
Is the digraph's underlying graph a tree?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_tree()}\if{html}{\out{</div>}}
}

\subsection{Details}{
It is a tree if it is connected and acyclic.
}

\subsection{Returns}{
\code{TRUE} if the underlying graph is a tree; \code{FALSE} 
if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-is_polytree"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-is_polytree}{}}}
\subsection{Method \code{is_polytree()}}{
Is the digraph's underlying graph a polytree?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_polytree()}\if{html}{\out{</div>}}
}

\subsection{Details}{
It is a polytree if it is directed, connected and acyclic.
Because the object is a digraph (directed), this is synonymous with
\code{tree}.
}

\subsection{Returns}{
\code{TRUE} if the underlying graph is a tree; \code{FALSE}
if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-is_arborescence"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-is_arborescence}{}}}
\subsection{Method \code{is_arborescence()}}{
Is the digraph an arborescence?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_arborescence()}\if{html}{\out{</div>}}
}

\subsection{Details}{
An \dfn{arborescence} is a tree with a single root and unique
paths from the root.
}

\subsection{Returns}{
\code{TRUE} if the digraph is an arborescence; \code{FALSE}
if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-direct_successors"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-direct_successors}{}}}
\subsection{Method \code{direct_successors()}}{
Find the direct successors of a node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$direct_successors(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{The index vertex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of nodes or an empty list if the specified
node has no successors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-direct_predecessors"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-direct_predecessors}{}}}
\subsection{Method \code{direct_predecessors()}}{
Find the direct predecessors of a node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$direct_predecessors(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{The index vertex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of nodes or an empty list if the specified
node has no predecessors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-paths"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-paths}{}}}
\subsection{Method \code{paths()}}{
Find all directed simple paths from source to target.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$paths(s, t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{Source node.}

\item{\code{t}}{Target node.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
In simple paths all vertexes are unique. Uses a recursive 
depth-first search algorithm.
}

\subsection{Returns}{
A list of ordered node lists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-walk"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-walk}{}}}
\subsection{Method \code{walk()}}{
Sequence of edges which join the specified path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$walk(P, what = "edge")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{A list of Nodes}

\item{\code{what}}{One of "edge" or "index".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of Edges for \code{what = "edge"} or a list of Edge
indices for \code{what = "index"}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-as_DOT"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-as_DOT}{}}}
\subsection{Method \code{as_DOT()}}{
Exports the digraph in DOT notation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$as_DOT()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Writes a representation of the digraph in the 
\code{graphviz} DOT language 
(\url{http://graphviz.org/doc/info/lang.html}) for drawing with one
of the \code{graphviz} tools, including \code{dot} (Gansner, 1993).
}

\subsection{Returns}{
A character vector. Intended for passing to \code{writeLines}
for saving as a text file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Digraph-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Digraph-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
