% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogue.R
\name{catalogue}
\alias{catalogue}
\title{Get catalogue of DEFRA stations}
\usage{
catalogue(site_name = "", pollutant = 9999, group_id = 9999,
  closed = "true", country_id = 9999, region_id = 9999,
  location_type = 9999, search = "Search+Network", view = "advanced",
  action = "results")
}
\arguments{
\item{site_name}{This is the name of a specific site (by default this is left blank to get info on all the available sites.}

\item{pollutant}{This is a number from 1 to 99.}

\item{group_id}{This is the identification number of a group of stations.}

\item{closed}{This is "true" to include closed stations, "false" otherwise.}

\item{country_id}{This is the identification number of the country, it can be a number from 1 to 9. Default is 9999, which means all the countries.}

\item{region_id}{This is the identification number of the region, it can be a number from 1 to 9. Default is 9999, which means all the regions.}

\item{location_type}{This is the identification number of the location, it can be a number from 1 to 9. Default is 9999, which means all the locations.}

\item{search}{default is "Search+Network".}

\item{view}{default is "advanced".}

\item{action}{default is "results".}
}
\value{
A named vector containing Easting and Northing coordinates.
}
\description{
This function fetches the catalogue of monitoring stations from DEFRA's website.
}
\details{
\code{Pollutant} is defined based on the following convention: 1 = ozone, 2 = .
}
\examples{
# catalogue()

}

