% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreativeTemplateService.R
\name{dfp_getCreativeTemplatesByStatement}
\alias{dfp_getCreativeTemplatesByStatement}
\title{CreativeTemplateService}
\usage{
dfp_getCreativeTemplatesByStatement(request_data, as_df = FALSE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getCreativeTemplatesByStatementResponse
}
\description{
Provides methods for retrieving CreativeTemplate objects.
}
\details{
getCreativeTemplatesByStatement

Gets a CreativeTemplatePage of CreativeTemplate objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{name}
  \item{type}
  \item{status}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getCreativeTemplatesByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/CreativeTemplateService#getCreativeTemplatesByStatement}{Google Documentation for getCreativeTemplatesByStatement}
}
