% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/farthest_point_sampling.R
\name{farthest_point_sampling}
\alias{farthest_point_sampling}
\title{Farthest point sampling}
\usage{
farthest_point_sampling(mat, metric = "precomputed", k = nrow(mat),
  initial_point_index = 1L, return_clusters = FALSE)
}
\arguments{
\item{mat}{Original distance matrix}

\item{metric}{Distance metric to use (either "precomputed" or a metric from \code{\link{rdist}})}

\item{k}{Number of points to sample}

\item{initial_point_index}{Index of p_1}

\item{return_clusters}{Should the indices of the closest farthest points be returned?}
}
\description{
Farthest point sampling returns a reordering of the metric 
space P = {p_1, ..., p_k}, such that each p_i is the farthest 
point from the first i-1 points.
}
\examples{

# generate data
df <- matrix(runif(200), ncol = 2)
dist_mat <- pdist(df)
# farthest point sampling
fps <- farthest_point_sampling(dist_mat)
fps2 <- farthest_point_sampling(df, metric = "euclidean")
all.equal(fps, fps2)
# have a look at the fps distance matrix
rdist(df[fps[1:5], ])
dist_mat[fps, fps][1:5, 1:5]
}
