% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity-components.R
\name{norm_beta}
\alias{norm_beta}
\title{Normalised beta (low level diversity component)}
\usage{
norm_beta(meta)
}
\arguments{
\item{meta}{object of class \code{metacommunity}}
}
\value{
\code{norm_beta} returns an object of class \code{relativeentropy}
}
\description{
Calculates the low-level diversity component necessary for calculating
normalised beta diversity.
}
\details{
Values generated from \code{norm_beta()} may be input into \code{subdiv()} and
\code{metadiv()} to calculate normalised subcommunity and metacommunity beta
diversity.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate normalised beta component
b <- norm_beta(meta)
subdiv(b, 1)
metadiv(b, 1)

}
\references{
R. Reeve, T. Leinster, C. Cobbold, J. Thompson, N. Brummitt,
S. Mitchell, and L. Matthews. 2016. How to partition diversity.
arXiv 1404.6520v3:1–9.
}
