% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdmc.R
\name{rdmc}
\alias{rdmc}
\title{Analysis of RD designs with multiple cutoffs}
\usage{
rdmc(Y, X, C, pooled.opt = NULL, hvec = NULL, bvec = NULL, pvec = NULL,
  kernelvec = NULL, fuzzy = NULL, plot = FALSE, verbose = FALSE)
}
\arguments{
\item{Y}{outcome variable.}

\item{X}{running variable.}

\item{C}{cutoff variable.}

\item{pooled.opt}{options to be passed to \code{rdrobust()} to calculate pooled estimand.}

\item{hvec}{bandwidths to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{bvec}{bandwidths for the bias to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{pvec}{order of the polynomials to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{kernelvec}{kernels to be passed to \code{rdrobust()} to calculate cutoff-specific estimates.Should be a vector of length equal to the number of different cutoffs.}

\item{fuzzy}{specifies a fuzzy design.}

\item{plot}{plots cutoff-specific estimates and weights.}

\item{verbose}{displays the output from \code{rdrobust} for estimating the pooled estimand.}
}
\value{
\item{tau}{pooled estimate}
\item{se.rb}{robust bias corrected standard error for pooled estimate}
\item{pv.rb}{robust bias corrected p-value for pooled estimate}
\item{ci.rb.l}{left limit of robust bias corrected CI for pooled estimate}
\item{ci.rb.r}{right limit of robust bias corrected CI for pooled estimate}
\item{hl}{bandwidth to the left of the cutoff for pooled estimate}
\item{hr}{bandwidth to the right of the cutoff for pooled estimate}
\item{Nhl}{sample size within bandwidth to the left of the cutoff for pooled estimate}
\item{Nhr}{sample size within bandwidth to the right of the cutoff for pooled estimate}
\item{B}{vector of bias-corrected coefficients}
\item{V}{variance-covariance matrix of the estimators}
\item{Coefs}{vector of conventional coefficients}
\item{W}{vector of weights for each cutoff-specific estimate}
\item{Nh}{vector of sample sizes within bandwidth at each cutoff}
\item{CI}{bias corrected confidence intervals}
\item{H}{bandwidth used at each cutoff}
\item{rdrobust.results}{results from rdrobust for pooled estimate}
}
\description{
\code{rdmc()} analyzes RD designs with multiple cutoffs.
}
\examples{
# Toy dataset
X <- runif(1000,0,100)
C <- c(rep(33,500),rep(66,500))
Y <- (1 + X + (X>=C))*(C==33)+(.5 + .5*X + .8*(X>=C))*(C==66) + rnorm(1000)
# rdmc with standard syntax
tmp <- rdmc(Y,X,C)
# rdmc with cutoff-specific bandwidths
tmp <- rdmc(Y,X,C,hvec=c(9,13))


}
\references{
M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2018). \href{https://sites.google.com/site/rdpackages/rdmulti/Cattaneo-Titiunik-VazquezBare_2018_rdmulti.pdf}{Analysis of Regression Discontinuity Designs with Multiple Cutoffs or Multiple Scores}. \emph{Working paper, University of Michigan}.
}
\author{
Matias Cattaneo, University of Michigan. \email{cattaneo@umich.edu}

Rocio Titiunik, University of Michigan. \email{titiunik@umich.edu}

Gonzalo Vazquez-Bare, University of Michigan. \email{gvazquez@umich.edu}
}
